# Dummy User Credentials for Testing

All dummy users have been created and are ready for testing. Use these credentials to log in and test each role's functionality.

## 🔐 IMPORTANT: Login Information

**Login URL:** http://localhost:8080/login

All users can login using **Email + Password** method (no OTP needed for testing).

## User Credentials

### 1. 👑 Super Admin Account
- **Email:** `superadmin@flex.com`
- **Password:** `Super@123`
- **Role:** Super Admin
- **Dashboard:** http://localhost:8080/superadmin/dashboard
- **Features to Test:**
  - Manage admin accounts (create, update, delete)
  - View all users (buyers, sellers, delivery persons)
  - System-wide settings
  - Advanced reports
  - User blocking/unblocking
  - Reliability score management
  - Transaction monitoring
  - Pin code management
  - Listing types management
  - Delivery formula settings
  - Commission and GST settings
  - Category and brand management
  - Advertisement management

### 2. 🔧 Admin Account
- **Email:** `admin@flex.com`
- **Password:** `Admin@123`
- **Role:** Admin
- **Dashboard:** http://localhost:8080/admin/dashboard
- **Features to Test:**
  - Review and approve pending products
  - Manage all orders
  - Assign delivery persons to orders
  - View system reports
  - Monitor buyer and seller activity
  - Manage notifications
  - View analytics
  - Block/unblock users
  - Mark BGV as cleared
  - Update delivery status
  - Extend rental dates

### 3. 📦 Seller Account
- **Email:** `seller@flex.com`
- **Password:** `Seller@123`
- **Role:** Seller
- **Dashboard:** http://localhost:8080/seller/dashboard
- **Features to Test:**
  - Upload products
  - Manage brands
  - View and respond to buyer offers
  - Manage orders
  - View transactions
  - Analytics dashboard
  - Profile management
  - Subscription plans
  - Notifications
  - Help center

### 4. 🚚 Delivery Person Account
- **Email:** `delivery@flex.com`
- **Password:** `Delivery@123`
- **Role:** Delivery
- **Dashboard:** http://localhost:8080/delivery/dashboard
- **Delivery Person Details:**
  - Vehicle Type: Bike
  - Vehicle Number: DL01AB1234
  - License Number: DL1234567890
  - Available Cities: Delhi, Gurgaon, Noida
  - Status: Available
  - BGV Status: Cleared
- **Features to Test:**
  - View assigned orders
  - Accept delivery requests
  - Mark orders as picked up/delivered
  - View delivery history
  - View earnings
  - Update profile and KYC
  - Cancel delivery requests

**Note:** Orders are assigned by Admin when customers place orders. The delivery person cannot self-assign orders.

### 5. 🛍️ Buyer Account
- **Email:** `buyer@flex.com`
- **Password:** `Buyer@123`
- **Role:** Buyer
- **Dashboard:** http://localhost:8080/buyer
- **Features to Test:**
  - Browse products
  - Make offers on products
  - View my offers
  - Cancel offers
  - View my orders
  - Submit reviews
  - View transactions

## Testing Workflow

### Complete Order Flow (End-to-End Test)

1. **Buyer Creates Offer:**
   - Log in as buyer (use your existing buyer account)
   - Browse products at http://localhost:8080/buyer/browse
   - Make an offer on a product

2. **Seller Responds:**
   - Log out and log in as `seller@example.com`
   - Go to Offers page
   - Accept/reject the buyer's offer

3. **Admin Assigns Delivery:**
   - Log out and log in as `admin@example.com`
   - Go to Orders page
   - Find the order and assign `delivery@example.com` as delivery person

4. **Delivery Person Picks Up:**
   - Log out and log in as `delivery@example.com`
   - View assigned order
   - Mark as "Picked Up"

5. **Delivery Person Delivers:**
   - Mark order as "Delivered"
   - View earnings

6. **Buyer Reviews:**
   - Log in as buyer
   - Go to My Orders
   - Submit a review for the delivered product

## Database Information

- **Database Name:** `flex_market`
- **Server:** localhost
- **Port:** 3306 (default MySQL)
- **All tables:** users, products, product_images, brands, offers, orders, order_status_history, delivery_persons, transactions, reviews, notifications, admin_settings, allowed_locations

## Troubleshooting

### IMPORTANT: Verify Users Exist First
Before testing login, please verify the users exist in your database by visiting:
**http://localhost:8080/check-users**

This will show you:
- All dummy users and their roles
- Whether passwords are correctly hashed
- Whether delivery person entry exists

### If login fails:
1. Check if the user exists in database:
   ```sql
   SELECT * FROM users WHERE email = 'seller@example.com';
   ```

2. Verify password hash (all passwords use bcrypt):
   - Seller: sellerpass
   - Delivery: deliverypass
   - Admin: adminpass
   - Super Admin: superpass

### If dashboard redirects incorrectly:
- Clear browser cookies and session data
- Check `app/Config/Routes.php` for correct role-based routes
- Verify `app/Controllers/Auth.php` dashboard() method redirects

### If delivery person shows no orders:
- Remember: Delivery persons cannot see orders until Admin assigns them
- Admin must go to Orders page and manually assign delivery person
- Order must be in "pending" or "confirmed" status to be assigned

## Next Steps

1. Test all user logins
2. Create sample products as seller
3. Create sample offers as buyer
4. Test order assignment workflow
5. Test delivery workflow
6. Test review system
7. Test admin features
8. Test super admin features

## Notes

- All dummy users have been seeded into the database
- Delivery person entry has been created in `delivery_persons` table
- All routes are configured and working
- All views are created and ready to use
