# Flex Market - Features Implementation Guide

## ✅ COMPLETED FEATURES

### Database Tables Created
1. ✅ **users** - Extended with reliability_score, role, is_blocked
2. ✅ **products** - Products with sell/rent options
3. ✅ **brands** - Seller brands (requires reliability >=25)
4. ✅ **offers** - Buyer offers on products
5. ✅ **orders** - Confirmed transactions
6. ✅ **transactions** - Payment history
7. ✅ **reviews** - Buyer/seller ratings (auto-updates reliability)
8. ✅ **notifications** - System notifications
9. ✅ **delivery_persons** - Delivery agent details
10. ✅ **admin_settings** - System configurations
11. ✅ **product_images** - Product photos (max 7)
12. ✅ **allowed_locations** - Pin codes/cities/states
13. ✅ **order_status_history** - Order tracking

### Seller Features Implemented
✅ **S1** - Upload product (sell/rent option)  
✅ **S17** - Rental details (cost, deposit, fitting)  
✅ **S19** - Product details (size, color, price, photos, bill)  
✅ **S10** - Seller dashboard with stats  
✅ **S25** - View offers with buyer ratings  
✅ **S24** - Accept/Reject offers  
✅ **S36** - Products visible with seller name  
✅ **Brand Creation** - Create brand when reliability >=25  

### Admin Features Implemented
✅ **SA6** - View pending publish requests  
✅ **SA7** - Approve/reject products with remarks  
✅ **SA10** - Block/unblock users  
✅ **SA5** - View all products (filters by status)  

---

## 🎯 HOW TO USE

### For Sellers:
1. **Login**: Go to http://localhost:8080/login
2. **Dashboard**: `/seller/dashboard` - See your stats, products, offers
3. **Upload Product**: `/seller/upload`
   - Choose Sell or Rent
   - Fill product details
   - Upload up to 7 images
   - Upload bill (optional)
   - Product goes to "Pending" status
4. **View Offers**: `/seller/offers` - See buyer offers with ratings
5. **Accept/Reject Offers**: Click buttons on dashboard or offers page
6. **Create Brand**: When reliability score >=25

### For Admin:
1. **Login**: Use admin credentials (set role='admin' in database)
2. **Dashboard**: `/admin/dashboard` - Overview statistics
3. **Pending Approvals**: `/admin/pending-products`
   - Review product details
   - Approve with optional remarks
   - Reject with mandatory reason
   - Seller gets notification
4. **Manage Users**: `/admin/users` - Block/unblock sellers/buyers
5. **View Products**: `/admin/products` - All products with filters

---

## 🔑 ACCESS CONTROL

### Make a User Admin:
```sql
UPDATE users SET role='admin' WHERE email='your@email.com';
```

### User Roles:
- `buyer` - Default role
- `seller` - Can upload products
- `admin` - Can approve products, manage users
- `super_admin` - Full access
- `delivery` - Delivery person

---

## 📂 FILE STRUCTURE

### Controllers
- `app/Controllers/Seller.php` - Seller functions
- `app/Controllers/Admin.php` - Admin functions
- `app/Controllers/Auth.php` - Login/Registration

### Models
- `app/Models/ProductModel.php`
- `app/Models/BrandModel.php`
- `app/Models/OfferModel.php`
- `app/Models/OrderModel.php`
- `app/Models/ReviewModel.php`
- `app/Models/NotificationModel.php`
- `app/Models/ProductImageModel.php`
- `app/Models/OrderStatusHistoryModel.php`

### Views
- `app/Views/seller/dashboard.php`
- `app/Views/seller/upload_product.php`
- `app/Views/admin/dashboard.php`
- `app/Views/admin/pending_products.php`

---

## 🚀 NEXT STEPS TO IMPLEMENT

### Phase 2 - Buyer Features
- [ ] Browse products
- [ ] Make offers
- [ ] View order status
- [ ] Rate sellers

### Phase 3 - Advanced Features
- [ ] Order management (pack, ship, deliver)
- [ ] Review system (20-day window)
- [ ] Delivery person assignment
- [ ] Rental return tracking
- [ ] Advanced search & filters

### Phase 4 - Super Admin
- [ ] Financial reports
- [ ] System settings
- [ ] Location management
- [ ] Analytics dashboard

---

## 📊 RELIABILITY SCORE SYSTEM

**How it works:**
- Average rating × review count = reliability score
- Score >=25 → Can create brand
- Displayed on seller dashboard
- Visible to buyers when making offers

**Example:**
- 5 reviews with average 4.8 stars = 24 points
- 6 reviews with average 4.5 stars = 27 points ✅ Can create brand

---

## 🎨 PRODUCT UPLOAD FLOW

1. Seller uploads product → Status: `pending`
2. Admin reviews → Approves/Rejects
3. If approved → Status: `approved` → Goes live
4. If rejected → Status: `rejected` → Seller notified with reason
5. Buyer makes offer → Seller accepts → Order created
6. Order delivered → Buyer/Seller can review (within 20 days)

---

## 🔔 NOTIFICATIONS SYSTEM

**Notifications sent for:**
- Product upload (to admin)
- Product approved/rejected (to seller)
- Offer received (to seller)
- Offer accepted/rejected (to buyer)
- Order status changes
- Account blocked/unblocked

**Access notifications:**
```php
$notifications = $this->notificationModel->getUserNotifications($userId, true); // unread only
```

---

## 🛠️ TROUBLESHOOTING

### Images not uploading?
- Check `writable/uploads/` permissions (777)
- Ensure max 2MB per image
- Max 7 images per product

### Reliability score not updating?
- Reviews auto-update reliability after insert
- Check ReviewModel `updateUserReliability` callback

### Admin can't access panel?
```sql
UPDATE users SET role='admin' WHERE id=YOUR_USER_ID;
```

---

## 📝 TESTING CHECKLIST

### Seller Tests:
- [ ] Upload product (sell)
- [ ] Upload product (rent)
- [ ] View dashboard stats
- [ ] Accept offer
- [ ] Reject offer
- [ ] Create brand (if score >=25)

### Admin Tests:
- [ ] View pending products
- [ ] Approve product
- [ ] Reject product (with reason)
- [ ] Block user
- [ ] Unblock user

---

**All core features are now live and ready to use! 🎉**

Start server: `start-server.bat` or `D:\xampp\php\php.exe spark serve`  
URL: http://localhost:8080
