<?php

use CodeIgniter\Router\RouteCollection;

/**
 * @var RouteCollection $routes
 */
$routes->get('/', 'Buyer::index'); // Main site shows buyer products
$routes->get('/index', 'Buyer::index');
$routes->get('/login', 'Home::index'); // Login page still exists
$routes->get('/check-users', 'Home::checkUsers'); // Test route
$routes->get('/test-session', 'TestSession::index'); // Session test route

// Authentication Routes
$routes->get('/register', 'Auth::register');
$routes->post('/auth/process-register', 'Auth::processRegister');
$routes->get('/auth/login', 'Auth::login');
$routes->post('/auth/send-login-otp', 'Auth::sendLoginOTP');
$routes->post('/auth/process-password-login', 'Auth::processPasswordLogin');
$routes->get('/verify-otp', 'Auth::verifyOTP');
$routes->post('/auth/process-verify-otp', 'Auth::processVerifyOTP');
$routes->get('/auth/logout', 'Auth::logout');
$routes->get('/dashboard', 'Auth::dashboard');

// Seller Routes
$routes->group('seller', ['filter' => 'auth'], function($routes) {
    $routes->get('dashboard', 'Seller::dashboard');
    $routes->get('upload', 'Seller::uploadProduct');
    $routes->post('process-upload', 'Seller::processUpload');
    $routes->get('products', 'Seller::myProducts');
    $routes->get('offers', 'Seller::offers');
    $routes->post('accept-offer/(:num)', 'Seller::acceptOffer/$1');
    $routes->post('reject-offer/(:num)', 'Seller::rejectOffer/$1');
    $routes->get('orders', 'Seller::orders');
    $routes->get('order/(:num)', 'Seller::orderDetails/$1');
    $routes->post('mark-dispatched/(:num)', 'Seller::markDispatched/$1');
    $routes->get('transactions', 'Seller::transactions');
    $routes->get('analytics', 'Seller::analytics');
    $routes->get('brands', 'Seller::brands');
    $routes->post('create-brand', 'Seller::createBrand');
    $routes->post('update-brand', 'Seller::updateBrand');
    $routes->post('delete-brand/(:num)', 'Seller::deleteBrand/$1');
    $routes->get('profile', 'Seller::profile');
    $routes->get('subscription', 'Seller::subscription');
    $routes->get('notifications', 'Seller::notifications');
    $routes->get('help', 'Seller::help');
});

// Admin Routes
$routes->group('admin', ['filter' => 'auth'], function($routes) {
    $routes->get('dashboard', 'Admin::dashboard');
    
    // Product Management (SA6, SA7, SA8)
    $routes->get('pending-products', 'Admin::pendingProducts');
    $routes->post('approve-product/(:num)', 'Admin::approveProduct/$1');
    $routes->post('reject-product/(:num)', 'Admin::rejectProduct/$1');
    $routes->get('products', 'Admin::allProducts');
    
    // User Management (SA9-SA12)
    $routes->get('users', 'Admin::users');
    $routes->post('block-user/(:num)', 'Admin::blockUser/$1');
    $routes->post('unblock-user/(:num)', 'Admin::unblockUser/$1');
    
    // BGV Management (SA2)
    $routes->post('mark-bgv-cleared/(:num)', 'Admin::markBGVCleared/$1');
    
    // Order Management
    $routes->get('orders', 'Admin::orders');
    $routes->post('assign-delivery/(:num)', 'Admin::assignDelivery/$1');
    $routes->get('available-delivery-persons', 'Admin::getAvailableDeliveryPersons');
    
    // Delivery Status (SA15)
    $routes->post('update-delivery-status/(:num)', 'Admin::updateDeliveryStatus/$1');
    
    // Rental Extension (SA16)
    $routes->post('extend-rental-date/(:num)', 'Admin::extendRentalDate/$1');
    
    // Reports
    $routes->get('reports', 'Admin::reports');
});

// Buyer Routes
$routes->group('buyer', function($routes) {
    $routes->get('/', 'Buyer::index');
    $routes->get('product/(:num)', 'Buyer::productDetails/$1');
    $routes->post('make-offer', 'Buyer::makeOffer');
    $routes->get('my-offers', 'Buyer::myOffers', ['filter' => 'auth']);
    $routes->post('cancel-offer/(:num)', 'Buyer::cancelOffer/$1', ['filter' => 'auth']);
    $routes->get('transactions', 'Buyer::transactions', ['filter' => 'auth']);
    $routes->get('my-orders', 'Buyer::myOrders', ['filter' => 'auth']);
    $routes->post('submit-review', 'Buyer::submitReview', ['filter' => 'auth']);
});

// Delivery Routes
$routes->group('delivery', ['filter' => 'auth'], function($routes) {
    // D1, D3 - Profile Management
    $routes->get('profile', 'Delivery::profile');
    $routes->post('update-profile', 'Delivery::updateProfile');
    
    // D2 - KYC Management
    $routes->post('update-kyc', 'Delivery::updateKYC');
    
    // D3, D4 - Dashboard with BGV and KYC checks
    $routes->get('dashboard', 'Delivery::dashboard');
    
    // D2, D4 - Order Details
    $routes->get('order/(:num)', 'Delivery::orderDetails/$1');
    
    // D6-D10, D27, D28, D31 - Accept Delivery Request
    $routes->post('accept-delivery-request', 'Delivery::acceptDeliveryRequest');
    
    // D11-D16 - Delivery Status Marking
    $routes->post('mark-dispatched-as-is/(:num)', 'Delivery::markDispatchedAsIs/$1');
    $routes->post('mark-returned-as-is/(:num)', 'Delivery::markReturnedAsIs/$1');
    $routes->post('mark-dispatched-with-defects/(:num)', 'Delivery::markDispatchedWithDefects/$1');
    $routes->post('mark-returned-with-defects/(:num)', 'Delivery::markReturnedWithDefects/$1');
    $routes->post('mark-not-returned-by-buyer/(:num)', 'Delivery::markNotReturnedByBuyer/$1');
    $routes->post('mark-not-dispatched-by-seller/(:num)', 'Delivery::markNotDispatchedBySeller/$1');
    
    // D22-D26 - Cancel Delivery Request
    $routes->post('cancel-delivery-request/(:num)', 'Delivery::cancelDeliveryRequest/$1');
    
    // D29 - Delivery History and Earnings
    $routes->get('history', 'Delivery::history');
    $routes->get('earnings', 'Delivery::earnings');
    
    // D30 - Reminder Notifications (cron job endpoint)
    $routes->get('send-reminders', 'Delivery::sendPickupDropReminders');
});

// Super Admin Routes
$routes->group('superadmin', ['filter' => 'auth'], function($routes) {
    $routes->get('dashboard', 'SuperAdmin::dashboard');
    
    // Admin Management
    $routes->get('admins', 'SuperAdmin::admins');
    $routes->post('create-admin', 'SuperAdmin::createAdmin');
    $routes->post('delete-admin/(:num)', 'SuperAdmin::deleteAdmin/$1');
    
    // User Management
    $routes->get('users', 'SuperAdmin::users');
    $routes->post('toggle-user-status/(:num)', 'SuperAdmin::toggleUserStatus/$1');
    
    // BGV Management (SA1, SA2)
    $routes->post('mark-bgv-cleared/(:num)', 'SuperAdmin::markBGVCleared/$1');
    $routes->post('mark-bgv-cleared-bulk', 'SuperAdmin::markBGVClearedBulk');
    
    // Pin Code Management (SA3)
    $routes->get('pin-codes', 'SuperAdmin::managePinCodes');
    $routes->post('add-pin-code', 'SuperAdmin::addPinCode');
    $routes->post('remove-pin-code/(:num)', 'SuperAdmin::removePinCode/$1');
    
    // Listing Types Management (SA4)
    $routes->get('listing-types', 'SuperAdmin::manageListingTypes');
    $routes->post('add-listing-type', 'SuperAdmin::addListingType');
    $routes->post('remove-listing-type/(:num)', 'SuperAdmin::removeListingType/$1');
    
    // System Settings (SA5, SA14, SA30)
    $routes->get('settings', 'SuperAdmin::settings');
    $routes->post('update-settings', 'SuperAdmin::updateSettings');
    $routes->post('toggle-approval-required', 'SuperAdmin::toggleApprovalRequired');
    $routes->post('toggle-maintenance-mode', 'SuperAdmin::toggleMaintenanceMode');
    $routes->post('toggle-brand-creation', 'SuperAdmin::toggleBrandCreation');
    
    // Delivery Formula (SA13)
    $routes->post('update-delivery-formula', 'SuperAdmin::updateDeliveryFormula');
    
    // Rental Management (SA16)
    $routes->post('extend-rental-date/(:num)', 'SuperAdmin::extendRentalDate/$1');
    
    // Bank Security (SA17)
    $routes->get('bank-security', 'SuperAdmin::manageBankSecurity');
    
    // Badge Requirements (SA18)
    $routes->post('update-brand-badge-requirement', 'SuperAdmin::updateBrandBadgeRequirement');
    
    // Transaction Settings (SA19)
    $routes->post('update-min-transaction-amount', 'SuperAdmin::updateMinTransactionAmount');
    
    // Commission Settings (SA20)
    $routes->post('update-commission-rates', 'SuperAdmin::updateCommissionRates');
    
    // GST Settings (SA21)
    $routes->post('update-gst-rate', 'SuperAdmin::updateGSTRate');
    
    // Contact Viewing (SA22)
    $routes->post('update-contact-viewing-range', 'SuperAdmin::updateContactViewingRange');
    
    // Subscription Management (SA23, SA24)
    $routes->get('subscription-models', 'SuperAdmin::manageSubscriptionModels');
    $routes->post('add-subscription-model', 'SuperAdmin::addSubscriptionModel');
    $routes->post('update-subscription-model/(:num)', 'SuperAdmin::updateSubscriptionModel/$1');
    $routes->post('update-subscription-price-range', 'SuperAdmin::updateSubscriptionPriceRange');
    
    // Category Management (SA25)
    $routes->get('categories', 'SuperAdmin::manageCategories');
    $routes->post('add-category', 'SuperAdmin::addCategory');
    
    // Brand Management (SA26-SA28)
    $routes->get('brands', 'SuperAdmin::manageBrands');
    $routes->post('create-brand', 'SuperAdmin::createBrand');
    $routes->post('tag-product-to-brand', 'SuperAdmin::tagProductToBrand');
    $routes->post('block-brand/(:num)', 'SuperAdmin::blockBrand/$1');
    $routes->post('unblock-brand/(:num)', 'SuperAdmin::unblockBrand/$1');
    
    // Advertisement Management (SA29)
    $routes->get('advertisements', 'SuperAdmin::manageAdvertisements');
    $routes->post('upload-advertisement', 'SuperAdmin::uploadAdvertisement');
    $routes->post('toggle-advertisement/(:num)', 'SuperAdmin::toggleAdvertisement/$1');
    
    // Reports
    $routes->get('reports', 'SuperAdmin::reports');
});
