<?php

namespace App\Controllers;

class Home extends BaseController
{
    public function index(): string
    {
        return view('login');
    }

    public function checkUsers()
    {
        $db = \Config\Database::connect();
        
        $users = $db->table('users')
            ->whereIn('email', ['seller@example.com', 'delivery@example.com', 'admin@example.com', 'superadmin@example.com'])
            ->get()
            ->getResultArray();

        echo "<h2>Dummy Users Check</h2>";
        echo "<style>body{font-family:monospace;padding:20px;} .pass{color:green;font-weight:bold;} .fail{color:red;font-weight:bold;}</style>";
        echo "<pre>";
        
        foreach ($users as $user) {
            echo str_repeat('=', 60) . "\n";
            echo "Email: {$user['email']}\n";
            echo "Role: {$user['role']}\n";
            echo "User Type: {$user['user_type']}\n";
            echo "ID: {$user['id']}\n";
            echo "Has Password: " . (!empty($user['password']) ? 'Yes' : 'No') . "\n";
            echo "Is Verified: " . ($user['is_verified'] ? 'Yes' : 'No') . "\n";
            echo "Is Blocked: " . ($user['is_blocked'] ? 'Yes' : 'No') . "\n";
            
            // Test passwords
            $testPasswords = [
                'seller@example.com' => 'sellerpass',
                'delivery@example.com' => 'deliverypass',
                'admin@example.com' => 'adminpass',
                'superadmin@example.com' => 'superpass',
            ];
            
            $expectedPass = $testPasswords[$user['email']] ?? '';
            if ($expectedPass) {
                $verified = password_verify($expectedPass, $user['password']);
                echo "Password Verified: ";
                echo $verified ? '<span class="pass">YES ✓</span>' : '<span class="fail">NO ✗</span>';
                echo "\n";
                
                // Try manual login
                if ($verified) {
                    $userModel = new \App\Models\UserModel();
                    $verifyResult = $userModel->verifyPassword($user['email'], $expectedPass);
                    echo "UserModel::verifyPassword(): ";
                    echo $verifyResult ? '<span class="pass">YES ✓</span>' : '<span class="fail">NO ✗</span>';
                    echo "\n";
                }
            }
            
            echo "\n";
        }
        
        // Check delivery_persons table
        echo str_repeat('=', 60) . "\n";
        echo "DELIVERY PERSON ENTRY\n";
        echo str_repeat('=', 60) . "\n\n";
        $deliveryPerson = $db->table('delivery_persons')
            ->join('users', 'users.id = delivery_persons.user_id')
            ->where('users.email', 'delivery@example.com')
            ->get()
            ->getRowArray();

        if ($deliveryPerson) {
            echo "Found delivery person entry:\n";
            echo "User ID: {$deliveryPerson['user_id']}\n";
            echo "Vehicle: {$deliveryPerson['vehicle_type']}\n";
            echo "Vehicle Number: {$deliveryPerson['vehicle_number']}\n";
            echo "Available Cities: {$deliveryPerson['available_cities']}\n";
            echo "Is Available: " . ($deliveryPerson['is_available'] ? 'Yes' : 'No') . "\n";
        } else {
            echo '<span class="fail">No delivery person entry found!</span>' . "\n";
        }
        
        echo "</pre>";
    }
}

