<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Pending Product Approvals - Admin</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.css">
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <style>
        * {
            font-family: 'Poppins', sans-serif;
        }
        .product-card {
            border-radius: 10px;
            transition: transform 0.2s;
        }
        .product-card:hover {
            transform: translateY(-5px);
            box-shadow: 0 8px 16px rgba(0,0,0,0.1);
        }
        .product-images {
            display: flex;
            gap: 5px;
            flex-wrap: wrap;
        }
        .product-images img {
            width: 80px;
            height: 80px;
            object-fit: cover;
            border-radius: 5px;
        }
    </style>
</head>
<body class="bg-light">
    <div class="container-fluid p-4">
        <div class="d-flex justify-content-between align-items-center mb-4">
            <h2><i class="bi bi-clock-history"></i> Pending Product Approvals</h2>
            <a href="<?= base_url('admin/dashboard') ?>" class="btn btn-outline-secondary">
                <i class="bi bi-arrow-left"></i> Back to Dashboard
            </a>
        </div>

        <?php if (session()->getFlashdata('success')): ?>
            <div class="alert alert-success alert-dismissible fade show">
                <?= session()->getFlashdata('success') ?>
                <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
            </div>
        <?php endif; ?>

        <?php if (count($products) > 0): ?>
            <div class="row g-4">
                <?php foreach ($products as $product): ?>
                    <div class="col-md-6 col-lg-4">
                        <div class="card product-card">
                            <div class="card-body">
                                <h5 class="card-title"><?= esc($product['title']) ?></h5>
                                <p class="text-muted mb-2">
                                    <i class="bi bi-tag"></i> <?= esc($product['category']) ?>
                                    <span class="badge bg-<?= $product['listing_type'] === 'sell' ? 'primary' : 'info' ?> ms-2">
                                        <?= ucfirst($product['listing_type']) ?>
                                    </span>
                                </p>
                                
                                <div class="mb-2">
                                    <strong>Price:</strong> ₹<?= number_format($product['price'], 2) ?>
                                    <?php if ($product['listing_type'] === 'rent'): ?>
                                        <br><small class="text-muted">
                                            Rental: ₹<?= number_format($product['rental_cost'] ?? 0, 2) ?>/day
                                        </small>
                                    <?php endif; ?>
                                </div>

                                <div class="mb-2">
                                    <strong>Seller:</strong> <?= esc($product['seller_name']) ?><br>
                                    <small class="text-muted">
                                        <i class="bi bi-envelope"></i> <?= esc($product['seller_email']) ?><br>
                                        <i class="bi bi-phone"></i> <?= esc($product['mobile']) ?>
                                    </small>
                                </div>

                                <div class="mb-3">
                                    <strong>Description:</strong>
                                    <p class="small"><?= substr(esc($product['description']), 0, 100) ?>...</p>
                                </div>

                                <?php if ($product['has_bill']): ?>
                                    <div class="mb-2">
                                        <span class="badge bg-success">
                                            <i class="bi bi-check-circle"></i> Has Bill
                                        </span>
                                    </div>
                                <?php endif; ?>

                                <div class="mb-3">
                                    <small class="text-muted">
                                        <i class="bi bi-images"></i> <?= $product['image_count'] ?> images uploaded
                                    </small>
                                </div>

                                <div class="d-grid gap-2">
                                    <button class="btn btn-success" onclick="approveProduct(<?= $product['id'] ?>, '<?= esc($product['title']) ?>')">
                                        <i class="bi bi-check-circle"></i> Approve
                                    </button>
                                    <button class="btn btn-danger" onclick="rejectProduct(<?= $product['id'] ?>, '<?= esc($product['title']) ?>')">
                                        <i class="bi bi-x-circle"></i> Reject
                                    </button>
                                    <button class="btn btn-outline-info btn-sm" onclick="viewDetails(<?= $product['id'] ?>)">
                                        <i class="bi bi-eye"></i> View Full Details
                                    </button>
                                </div>

                                <div class="mt-2 text-muted small">
                                    <i class="bi bi-calendar"></i> Submitted: <?= date('d M Y, h:i A', strtotime($product['created_at'])) ?>
                                </div>
                            </div>
                        </div>
                    </div>
                <?php endforeach; ?>
            </div>
        <?php else: ?>
            <div class="text-center py-5">
                <i class="bi bi-check-circle-fill text-success" style="font-size: 4rem;"></i>
                <h4 class="mt-3">All Caught Up!</h4>
                <p class="text-muted">No pending products to review.</p>
                <a href="<?= base_url('admin/dashboard') ?>" class="btn btn-primary">Back to Dashboard</a>
            </div>
        <?php endif; ?>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
    <script>
        function approveProduct(productId, title) {
            const remarks = prompt(`Approve "${title}"?\n\nOptional remarks:`);
            if (remarks !== null) {
                fetch(`/admin/approve-product/${productId}`, {
                    method: 'POST',
                    headers: {
                        'Content-Type': 'application/json',
                        'X-Requested-With': 'XMLHttpRequest'
                    },
                    body: JSON.stringify({ remarks: remarks })
                })
                .then(res => res.json())
                .then(data => {
                    alert(data.message);
                    if (data.success) {
                        location.reload();
                    }
                })
                .catch(err => {
                    alert('Error approving product');
                });
            }
        }

        function rejectProduct(productId, title) {
            const reason = prompt(`Reject "${title}"?\n\nPlease provide a reason (required):`);
            if (reason && reason.trim()) {
                fetch(`/admin/reject-product/${productId}`, {
                    method: 'POST',
                    headers: {
                        'Content-Type': 'application/json',
                        'X-Requested-With': 'XMLHttpRequest'
                    },
                    body: JSON.stringify({ remarks: reason })
                })
                .then(res => res.json())
                .then(data => {
                    alert(data.message);
                    if (data.success) {
                        location.reload();
                    }
                })
                .catch(err => {
                    alert('Error rejecting product');
                });
            } else {
                alert('Rejection reason is required');
            }
        }

        function viewDetails(productId) {
            alert('Product details view coming soon!\nProduct ID: ' + productId);
        }
    </script>
</body>
</html>
