<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Delivery Dashboard - Flex Market</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.css">
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <style>
        * { font-family: 'Poppins', sans-serif; }
        body { background: #f5f5f5; }
        .sidebar {
            min-height: 100vh;
            background: linear-gradient(180deg, #00897b 0%, #00695c 100%);
            box-shadow: 2px 0 10px rgba(0,0,0,0.1);
        }
        .sidebar .nav-link {
            color: rgba(255,255,255,0.85);
            padding: 14px 20px;
            border-radius: 10px;
            margin: 6px 0;
            transition: all 0.3s;
        }
        .sidebar .nav-link:hover, .sidebar .nav-link.active {
            background: rgba(255,255,255,0.15);
            color: #fff;
            transform: translateX(5px);
        }
        .sidebar .nav-link i { margin-right: 10px; width: 20px; }
        .stat-card {
            background: white;
            border-radius: 15px;
            padding: 24px;
            box-shadow: 0 2px 15px rgba(0,0,0,0.08);
            transition: transform 0.3s;
        }
        .stat-card:hover {
            transform: translateY(-5px);
            box-shadow: 0 5px 25px rgba(0,0,0,0.12);
        }
        .stat-icon {
            width: 60px;
            height: 60px;
            border-radius: 12px;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 24px;
        }
        .gradient-teal { background: linear-gradient(135deg, #00897b 0%, #00695c 100%); }
        .gradient-orange { background: linear-gradient(135deg, #ff6f00 0%, #f4511e 100%); }
        .gradient-blue { background: linear-gradient(135deg, #1976d2 0%, #0d47a1 100%); }
        .gradient-green { background: linear-gradient(135deg, #388e3c 0%, #1b5e20 100%); }
        .order-card {
            background: white;
            border-radius: 12px;
            padding: 20px;
            margin-bottom: 15px;
            box-shadow: 0 2px 10px rgba(0,0,0,0.06);
            transition: all 0.3s;
        }
        .order-card:hover {
            transform: translateY(-3px);
            box-shadow: 0 5px 20px rgba(0,0,0,0.1);
        }
        .badge-pending { background: #ff9800; }
        .badge-in-transit { background: #2196f3; }
        .badge-delivered { background: #4caf50; }
        .badge-dispatched { background: #9c27b0; }
    </style>
</head>
<body>
    <div class="container-fluid">
        <div class="row">
            <!-- Sidebar -->
            <div class="col-md-3 col-lg-2 px-0 sidebar">
                <div class="p-3">
                    <h4 class="text-white mb-4"><i class="bi bi-truck"></i> Delivery Panel</h4>
                    <nav class="nav flex-column">
                        <a href="<?= base_url('delivery/dashboard') ?>" class="nav-link active">
                            <i class="bi bi-speedometer2"></i> Dashboard
                        </a>
                        <a href="<?= base_url('delivery/history') ?>" class="nav-link">
                            <i class="bi bi-clock-history"></i> Delivery History
                        </a>
                        <a href="<?= base_url('delivery/earnings') ?>" class="nav-link">
                            <i class="bi bi-currency-rupee"></i> Earnings
                        </a>
                        <a href="<?= base_url('auth/logout') ?>" class="nav-link mt-4">
                            <i class="bi bi-box-arrow-right"></i> Logout
                        </a>
                    </nav>
                </div>
            </div>

            <!-- Main Content -->
            <div class="col-md-9 col-lg-10 p-4">
                <!-- Header -->
                <div class="d-flex justify-content-between align-items-center mb-4">
                    <div>
                        <h2><i class="bi bi-speedometer2"></i> Delivery Dashboard</h2>
                        <p class="text-muted mb-0">Welcome, <?= esc($user['name'] ?? 'Delivery Partner') ?>!</p>
                        <small class="text-info">Orders are assigned to you by Admin when customers place orders</small>
                    </div>
                    <div class="badge bg-success fs-6">
                        <i class="bi bi-check-circle"></i> Active
                    </div>
                </div>

                <!-- Info Alert -->
                <div class="alert alert-info mb-4">
                    <strong><i class="bi bi-info-circle"></i> How it works:</strong><br>
                    1. Admin assigns orders to you when seller marks them as ready for dispatch<br>
                    2. Pick up the product from seller's location<br>
                    3. Mark as "Picked Up" in order details<br>
                    4. Deliver to buyer and mark as "Delivered"<br>
                    5. Earn ₹50 per successful delivery
                </div>

                <!-- Stats Cards -->
                <div class="row g-3 mb-4">
                    <div class="col-md-6 col-lg-3">
                        <div class="stat-card">
                            <div class="d-flex justify-content-between align-items-start">
                                <div>
                                    <p class="text-muted mb-1">Pending Pickups</p>
                                    <h3 class="mb-0"><?= $stats['pending'] ?? 0 ?></h3>
                                </div>
                                <div class="stat-icon gradient-orange text-white">
                                    <i class="bi bi-box"></i>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="col-md-6 col-lg-3">
                        <div class="stat-card">
                            <div class="d-flex justify-content-between align-items-start">
                                <div>
                                    <p class="text-muted mb-1">In Transit</p>
                                    <h3 class="mb-0"><?= $stats['in_transit'] ?? 0 ?></h3>
                                </div>
                                <div class="stat-icon gradient-blue text-white">
                                    <i class="bi bi-truck"></i>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="col-md-6 col-lg-3">
                        <div class="stat-card">
                            <div class="d-flex justify-content-between align-items-start">
                                <div>
                                    <p class="text-muted mb-1">Delivered Today</p>
                                    <h3 class="mb-0"><?= $stats['delivered'] ?? 0 ?></h3>
                                </div>
                                <div class="stat-icon gradient-green text-white">
                                    <i class="bi bi-check-circle"></i>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="col-md-6 col-lg-3">
                        <div class="stat-card">
                            <div class="d-flex justify-content-between align-items-start">
                                <div>
                                    <p class="text-muted mb-1">Total Earnings</p>
                                    <h3 class="mb-0">₹<?= number_format($totalEarnings ?? 0) ?></h3>
                                </div>
                                <div class="stat-icon gradient-teal text-white">
                                    <i class="bi bi-currency-rupee"></i>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Assigned Orders -->
                <div class="card border-0 shadow-sm">
                    <div class="card-body">
                        <h5 class="card-title mb-4"><i class="bi bi-list-ul"></i> Assigned Deliveries</h5>
                        
                        <?php if (!empty($assignedOrders)): ?>
                            <?php foreach ($assignedOrders as $order): ?>
                                <div class="order-card">
                                    <div class="row align-items-center">
                                        <div class="col-md-3">
                                            <h6 class="mb-1">Order #<?= esc($order['id']) ?></h6>
                                            <small class="text-muted"><?= date('d M Y', strtotime($order['created_at'])) ?></small>
                                        </div>
                                        <div class="col-md-2">
                                            <span class="badge badge-<?= strtolower(str_replace('_', '-', $order['status'])) ?>">
                                                <?= ucwords(str_replace('_', ' ', $order['status'])) ?>
                                            </span>
                                        </div>
                                        <div class="col-md-3">
                                            <small class="text-muted">Product:</small><br>
                                            <strong><?= esc($order['product_name']) ?></strong>
                                        </div>
                                        <div class="col-md-2">
                                            <small class="text-muted">Amount:</small><br>
                                            <strong>₹<?= number_format($order['final_price']) ?></strong>
                                        </div>
                                        <div class="col-md-2 text-end">
                                            <a href="<?= base_url('delivery/order/' . $order['id']) ?>" class="btn btn-sm btn-primary">
                                                <i class="bi bi-eye"></i> View
                                            </a>
                                        </div>
                                    </div>
                                </div>
                            <?php endforeach; ?>
                        <?php else: ?>
                            <div class="text-center py-5">
                                <i class="bi bi-inbox fs-1 text-muted"></i>
                                <p class="text-muted mt-3">No deliveries assigned at the moment</p>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>

                <!-- Completed Deliveries (Today) -->
                <div class="card border-0 shadow-sm mt-4">
                    <div class="card-body">
                        <h5 class="card-title mb-4"><i class="bi bi-check-all"></i> Completed Today</h5>
                        
                        <?php if (!empty($completedToday)): ?>
                            <?php foreach ($completedToday as $order): ?>
                                <div class="order-card">
                                    <div class="row align-items-center">
                                        <div class="col-md-3">
                                            <h6 class="mb-1">Order #<?= esc($order['id']) ?></h6>
                                            <small class="text-muted"><?= date('H:i', strtotime($order['delivery_date'])) ?></small>
                                        </div>
                                        <div class="col-md-2">
                                            <span class="badge badge-delivered">
                                                <i class="bi bi-check-circle"></i> Delivered
                                            </span>
                                        </div>
                                        <div class="col-md-3">
                                            <strong><?= esc($order['product_name']) ?></strong>
                                        </div>
                                        <div class="col-md-2">
                                            <strong>₹<?= number_format($order['final_price']) ?></strong>
                                        </div>
                                        <div class="col-md-2 text-end">
                                            <span class="badge bg-success">+₹50</span>
                                        </div>
                                    </div>
                                </div>
                            <?php endforeach; ?>
                        <?php else: ?>
                            <div class="text-center py-3">
                                <p class="text-muted">No deliveries completed today</p>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
