<?= $this->extend('delivery/layout') ?>

<?= $this->section('content') ?>

<div class="grid grid-cols-1 lg:grid-cols-3 gap-6 mb-8">
    <!-- Total Earnings Card -->
    <div class="lg:col-span-2 bg-gradient-to-br from-purple-600 to-purple-800 rounded-xl shadow-lg p-8 text-white">
        <div class="flex items-center justify-between mb-4">
            <h3 class="text-lg font-semibold opacity-90">Total Earnings</h3>
            <span class="text-4xl">💰</span>
        </div>
        <h1 class="text-5xl font-bold mb-2">₹<?= number_format($totalEarnings) ?></h1>
        <p class="text-purple-200">From <?= $totalDeliveries ?> completed deliveries</p>
    </div>

    <!-- Quick Stats -->
    <div class="space-y-4">
        <div class="bg-white rounded-xl shadow-md p-6">
            <div class="flex items-center justify-between mb-2">
                <p class="text-gray-600 text-sm font-medium">Today's Earnings</p>
                <span class="text-2xl">📅</span>
            </div>
            <h3 class="text-3xl font-bold text-green-600">₹<?= number_format($todayEarnings) ?></h3>
        </div>

        <div class="bg-white rounded-xl shadow-md p-6">
            <div class="flex items-center justify-between mb-2">
                <p class="text-gray-600 text-sm font-medium">This Week</p>
                <span class="text-2xl">📊</span>
            </div>
            <h3 class="text-3xl font-bold text-blue-600">₹<?= number_format($weekEarnings) ?></h3>
        </div>
    </div>
</div>

<!-- Earnings Breakdown -->
<div class="bg-white rounded-xl shadow-md p-6 mb-6">
    <h3 class="text-xl font-bold text-gray-800 mb-6 flex items-center">
        <span class="text-2xl mr-3">📈</span> Earnings Breakdown
    </h3>
    
    <div class="overflow-x-auto">
        <table class="w-full">
            <thead class="bg-gray-50">
                <tr>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Period</th>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Deliveries</th>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Amount</th>
                </tr>
            </thead>
            <tbody class="divide-y divide-gray-200">
                <tr class="hover:bg-gray-50">
                    <td class="px-6 py-4 whitespace-nowrap text-sm font-medium text-gray-900">Today</td>
                    <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500">
                        <?php
                        $todayCount = 0;
                        foreach ($completedDeliveries as $d) {
                            if (date('Y-m-d', strtotime($d['created_at'])) == date('Y-m-d')) $todayCount++;
                        }
                        echo $todayCount;
                        ?>
                    </td>
                    <td class="px-6 py-4 whitespace-nowrap text-sm font-semibold text-green-600">
                        ₹<?= number_format($todayEarnings) ?>
                    </td>
                </tr>
                <tr class="hover:bg-gray-50">
                    <td class="px-6 py-4 whitespace-nowrap text-sm font-medium text-gray-900">This Week</td>
                    <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500">
                        <?php
                        $weekCount = 0;
                        $weekStart = date('Y-m-d', strtotime('-7 days'));
                        foreach ($completedDeliveries as $d) {
                            if (date('Y-m-d', strtotime($d['created_at'])) >= $weekStart) $weekCount++;
                        }
                        echo $weekCount;
                        ?>
                    </td>
                    <td class="px-6 py-4 whitespace-nowrap text-sm font-semibold text-blue-600">
                        ₹<?= number_format($weekEarnings) ?>
                    </td>
                </tr>
                <tr class="bg-gray-50 font-bold">
                    <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900">All Time</td>
                    <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900"><?= $totalDeliveries ?></td>
                    <td class="px-6 py-4 whitespace-nowrap text-sm text-purple-600">
                        ₹<?= number_format($totalEarnings) ?>
                    </td>
                </tr>
            </tbody>
        </table>
    </div>
</div>

<!-- Payment Info -->
<div class="bg-white rounded-xl shadow-md p-6">
    <h3 class="text-xl font-bold text-gray-800 mb-4 flex items-center">
        <span class="text-2xl mr-3">🏦</span> Payment Details
    </h3>
    
    <div class="bg-blue-50 border-l-4 border-blue-500 p-4 mb-4">
        <p class="text-blue-800 text-sm">
            <span class="font-semibold">💡 Note:</span> Earnings are calculated at ₹50 per delivery. 
            Payments are processed weekly and transferred to your registered bank account.
        </p>
    </div>
    
    <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
        <div class="bg-gray-50 p-4 rounded-lg">
            <p class="text-sm text-gray-600 mb-1">Next Payout Date</p>
            <p class="font-semibold text-gray-800 text-lg"><?= date('d M Y', strtotime('next Friday')) ?></p>
        </div>
        
        <div class="bg-gray-50 p-4 rounded-lg">
            <p class="text-sm text-gray-600 mb-1">Pending Payout Amount</p>
            <p class="font-semibold text-purple-600 text-lg">₹<?= number_format($weekEarnings) ?></p>
        </div>
    </div>
</div>

<?= $this->endSection() ?>
