<?= $this->extend('delivery/layout') ?>

<?= $this->section('content') ?>

<div class="max-w-4xl">
    <!-- Status Alert -->
    <?php
    $kycVerified = $deliveryPerson['kyc_verified'] ?? 0;
    $bgvCleared = $user['bgv_cleared'] ?? 0;
    ?>
    
    <?php if (!$kycVerified || !$bgvCleared): ?>
    <div class="bg-yellow-50 border-l-4 border-yellow-400 p-6 mb-6 rounded-r-lg">
        <div class="flex items-start">
            <span class="text-3xl mr-4">⚠️</span>
            <div>
                <h3 class="font-bold text-yellow-800 mb-2">Verification Pending</h3>
                <p class="text-yellow-700 text-sm">
                    Complete your <?= !$kycVerified ? 'KYC verification' : '' ?>
                    <?= (!$kycVerified && !$bgvCleared) ? ' and ' : '' ?>
                    <?= !$bgvCleared ? 'background check' : '' ?> to start accepting deliveries.
                </p>
            </div>
        </div>
    </div>
    <?php endif; ?>

    <!-- Profile Form -->
    <div class="bg-white rounded-xl shadow-md p-6 mb-6">
        <h3 class="text-xl font-bold text-gray-800 mb-6 flex items-center">
            <span class="text-2xl mr-3">👤</span> Personal Information
        </h3>
        
        <form action="<?= base_url('delivery/update-profile') ?>" method="POST" class="space-y-4">
            <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-2">Full Name</label>
                    <input type="text" name="name" value="<?= esc($user['name']) ?>" 
                           class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-purple-500 focus:border-transparent"
                           required>
                </div>
                
                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-2">Mobile Number</label>
                    <input type="tel" name="mobile" value="<?= esc($user['mobile']) ?>" 
                           class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-purple-500 focus:border-transparent"
                           required>
                </div>
                
                <div class="md:col-span-2">
                    <label class="block text-sm font-medium text-gray-700 mb-2">Email</label>
                    <input type="email" name="email" value="<?= esc($user['email']) ?>" 
                           class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-purple-500 focus:border-transparent"
                           required>
                </div>
                
                <div class="md:col-span-2">
                    <label class="block text-sm font-medium text-gray-700 mb-2">Address</label>
                    <textarea name="address" rows="3" 
                              class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-purple-500 focus:border-transparent"
                              required><?= esc($user['address']) ?></textarea>
                </div>
                
                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-2">PIN Code</label>
                    <input type="text" name="pin_code" value="<?= esc($user['pin_code']) ?>" 
                           class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-purple-500 focus:border-transparent"
                           required>
                </div>
            </div>
            
            <button type="submit" class="px-6 py-2 bg-purple-600 text-white rounded-lg hover:bg-purple-700 transition font-medium">
                Update Profile
            </button>
        </form>
    </div>

    <!-- KYC Details -->
    <div class="bg-white rounded-xl shadow-md p-6 mb-6">
        <h3 class="text-xl font-bold text-gray-800 mb-6 flex items-center">
            <span class="text-2xl mr-3">📄</span> KYC Information
            <?php if ($kycVerified): ?>
                <span class="ml-auto px-3 py-1 bg-green-100 text-green-800 rounded-full text-sm font-medium">✓ Verified</span>
            <?php else: ?>
                <span class="ml-auto px-3 py-1 bg-yellow-100 text-yellow-800 rounded-full text-sm font-medium">⏳ Pending</span>
            <?php endif; ?>
        </h3>
        
        <form action="<?= base_url('delivery/update-kyc') ?>" method="POST" class="space-y-4">
            <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-2">PAN Card Number</label>
                    <input type="text" name="pan_card" value="<?= esc($deliveryPerson['pan_card'] ?? '') ?>" 
                           placeholder="ABCDE1234F"
                           class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-purple-500 focus:border-transparent uppercase"
                           maxlength="10" pattern="[A-Z]{5}[0-9]{4}[A-Z]{1}" required>
                    <p class="text-xs text-gray-500 mt-1">10 characters (e.g., ABCDE1234F)</p>
                </div>
                
                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-2">Aadhar Card Number</label>
                    <input type="text" name="aadhar_card" value="<?= esc($deliveryPerson['aadhar_card'] ?? '') ?>" 
                           placeholder="1234 5678 9012"
                           class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-purple-500 focus:border-transparent"
                           maxlength="12" pattern="[0-9]{12}" required>
                    <p class="text-xs text-gray-500 mt-1">12 digits</p>
                </div>
            </div>
            
            <?php if (!$kycVerified): ?>
            <button type="submit" class="px-6 py-2 bg-purple-600 text-white rounded-lg hover:bg-purple-700 transition font-medium">
                Submit for Verification
            </button>
            <?php else: ?>
            <p class="text-green-700 text-sm flex items-center">
                <span class="mr-2">✓</span> Your KYC documents have been verified by admin.
            </p>
            <?php endif; ?>
        </form>
    </div>

    <!-- Vehicle Details -->
    <?php if ($deliveryPerson): ?>
    <div class="bg-white rounded-xl shadow-md p-6">
        <h3 class="text-xl font-bold text-gray-800 mb-6 flex items-center">
            <span class="text-2xl mr-3">🏍️</span> Vehicle Information
        </h3>
        
        <div class="grid grid-cols-1 md:grid-cols-3 gap-4">
            <div class="bg-gray-50 p-4 rounded-lg">
                <p class="text-sm text-gray-600 mb-1">Vehicle Type</p>
                <p class="font-semibold text-gray-800"><?= ucfirst($deliveryPerson['vehicle_type'] ?? 'Not set') ?></p>
            </div>
            
            <div class="bg-gray-50 p-4 rounded-lg">
                <p class="text-sm text-gray-600 mb-1">Vehicle Number</p>
                <p class="font-semibold text-gray-800"><?= esc($deliveryPerson['vehicle_number'] ?? 'Not set') ?></p>
            </div>
            
            <div class="bg-gray-50 p-4 rounded-lg">
                <p class="text-sm text-gray-600 mb-1">License Number</p>
                <p class="font-semibold text-gray-800"><?= esc($deliveryPerson['license_number'] ?? 'Not set') ?></p>
            </div>
        </div>
    </div>
    <?php endif; ?>
</div>

<?= $this->endSection() ?>
