<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Register - Flex Market</title>
    
    <!-- Bootstrap 5 -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <!-- Bootstrap Icons -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.css" rel="stylesheet">
    <!-- Poppins Font -->
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;500;600;700&display=swap" rel="stylesheet">
    
    <style>
        body {
            font-family: 'Poppins', sans-serif;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            min-height: 100vh;
            display: flex;
            align-items: center;
            padding: 40px 0;
        }
        .register-container {
            max-width: 600px;
            margin: 0 auto;
        }
        .register-card {
            background: #fff;
            border-radius: 20px;
            padding: 40px;
            box-shadow: 0 10px 40px rgba(0,0,0,0.1);
        }
        .brand-title {
            font-weight: 700;
            font-size: 2rem;
            color: #000;
            text-align: center;
            margin-bottom: 10px;
        }
        .subtitle {
            text-align: center;
            color: #666;
            margin-bottom: 30px;
        }
        .form-label {
            font-weight: 500;
            color: #333;
            margin-bottom: 8px;
        }
        .form-control, .form-select {
            border-radius: 10px;
            padding: 12px 18px;
            border: 1px solid #ddd;
            font-size: 15px;
        }
        .form-control:focus, .form-select:focus {
            border-color: #ffc107;
            box-shadow: 0 0 0 0.2rem rgba(255, 193, 7, 0.25);
        }
        .user-type-toggle {
            display: flex;
            gap: 15px;
            margin-bottom: 20px;
        }
        .type-option {
            flex: 1;
            text-align: center;
        }
        .type-option input[type="radio"] {
            display: none;
        }
        .type-option label {
            display: block;
            padding: 15px;
            border: 2px solid #ddd;
            border-radius: 10px;
            cursor: pointer;
            transition: all 0.3s;
            font-weight: 500;
        }
        .type-option input[type="radio"]:checked + label {
            border-color: #ffc107;
            background-color: #ffc107;
            color: #fff;
        }
        .btn-register {
            background-color: #ffc107;
            color: #000;
            border: none;
            border-radius: 10px;
            padding: 14px;
            font-weight: 600;
            width: 100%;
            font-size: 16px;
            transition: all 0.3s;
        }
        .btn-register:hover {
            background-color: #000;
            color: #fff;
            transform: translateY(-2px);
            box-shadow: 0 6px 20px rgba(0,0,0,0.2);
        }
        .login-link {
            text-align: center;
            margin-top: 20px;
            color: #666;
        }
        .login-link a {
            color: #ffc107;
            text-decoration: none;
            font-weight: 600;
        }
        .login-link a:hover {
            text-decoration: underline;
        }
        .alert {
            border-radius: 10px;
            margin-bottom: 20px;
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="register-container">
            <div class="register-card">
                <h1 class="brand-title">Flex Market</h1>
                <p class="subtitle">Create your account</p>

                <?php if (session()->getFlashdata('error')): ?>
                    <div class="alert alert-danger">
                        <?= session()->getFlashdata('error') ?>
                    </div>
                <?php endif; ?>

                <?php if (session()->getFlashdata('errors')): ?>
                    <div class="alert alert-danger">
                        <ul class="mb-0">
                            <?php foreach (session()->getFlashdata('errors') as $error): ?>
                                <li><?= esc($error) ?></li>
                            <?php endforeach; ?>
                        </ul>
                    </div>
                <?php endif; ?>

                <form action="<?= base_url('auth/process-register') ?>" method="POST">
                    <?= csrf_field() ?>

                    <div class="mb-3">
                        <label class="form-label">I am a</label>
                        <div class="user-type-toggle">
                            <div class="type-option">
                                <input type="radio" name="user_type" id="buyer" value="buyer" checked>
                                <label for="buyer">
                                    <i class="bi bi-bag-check"></i> Buyer
                                </label>
                            </div>
                            <div class="type-option">
                                <input type="radio" name="user_type" id="seller" value="seller">
                                <label for="seller">
                                    <i class="bi bi-shop"></i> Seller
                                </label>
                            </div>
                        </div>
                    </div>

                    <div class="mb-3">
                        <label for="name" class="form-label">Full Name *</label>
                        <input type="text" class="form-control" id="name" name="name" 
                               value="<?= old('name') ?>" required placeholder="Enter your full name">
                    </div>

                    <div class="mb-3">
                        <label for="email" class="form-label">Email Address *</label>
                        <input type="email" class="form-control" id="email" name="email" 
                               value="<?= old('email') ?>" required placeholder="Enter your email">
                    </div>

                    <div class="mb-3">
                        <label for="mobile" class="form-label">Mobile Number *</label>
                        <input type="tel" class="form-control" id="mobile" name="mobile" 
                               value="<?= old('mobile') ?>" required placeholder="Enter your mobile number">
                    </div>

                    <div class="mb-3">
                        <label for="address" class="form-label">Address *</label>
                        <textarea class="form-control" id="address" name="address" rows="3" 
                                  required placeholder="Enter your complete address"><?= old('address') ?></textarea>
                    </div>

                    <div class="mb-4">
                        <label for="pin_code" class="form-label">PIN Code *</label>
                        <input type="text" class="form-control" id="pin_code" name="pin_code" 
                               value="<?= old('pin_code') ?>" required placeholder="Enter your PIN code">
                    </div>

                    <button type="submit" class="btn btn-register">
                        Register & Send OTP
                    </button>
                </form>

                <div class="login-link">
                    Already have an account? <a href="<?= base_url('login') ?>">Login here</a>
                </div>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
