<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Manage Brands - Flex Market</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.min.css">
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <style>
        body {
            font-family: 'Poppins', sans-serif;
            background: #f8f9fa;
            min-height: 100vh;
        }
        .content-wrapper {
            margin-left: 280px;
            padding: 30px;
        }
        .page-header {
            background: white;
            padding: 25px 30px;
            border-radius: 15px;
            margin-bottom: 30px;
            box-shadow: 0 2px 10px rgba(0,0,0,0.05);
        }
        .page-header h1 {
            color: #9c27b0;
            font-weight: 600;
            margin: 0;
        }
        .stats-cards {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
            gap: 20px;
            margin-bottom: 30px;
        }
        .stat-card {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            padding: 25px;
            border-radius: 15px;
            box-shadow: 0 4px 15px rgba(102, 126, 234, 0.3);
        }
        .stat-card h3 {
            font-size: 2rem;
            font-weight: 700;
            margin: 0 0 5px 0;
        }
        .stat-card p {
            margin: 0;
            opacity: 0.9;
        }
        .brand-card {
            background: white;
            border-radius: 15px;
            padding: 25px;
            margin-bottom: 20px;
            box-shadow: 0 2px 10px rgba(0,0,0,0.05);
            transition: all 0.3s;
        }
        .brand-card:hover {
            box-shadow: 0 5px 20px rgba(0,0,0,0.1);
            transform: translateY(-3px);
        }
        .brand-header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 15px;
        }
        .brand-name {
            font-size: 1.5rem;
            font-weight: 600;
            color: #2c3e50;
            margin: 0;
        }
        .brand-meta {
            color: #6c757d;
            font-size: 0.9rem;
            margin-bottom: 8px;
        }
        .btn-gradient {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            border: none;
            padding: 10px 24px;
            border-radius: 10px;
            font-weight: 500;
        }
        .btn-gradient:hover {
            opacity: 0.9;
            color: white;
        }
        .btn-edit {
            background: #17a2b8;
            color: white;
            padding: 6px 16px;
            border-radius: 8px;
            font-size: 0.9rem;
        }
        .btn-delete {
            background: #dc3545;
            color: white;
            padding: 6px 16px;
            border-radius: 8px;
            font-size: 0.9rem;
        }
        .empty-state {
            background: white;
            padding: 60px 20px;
            border-radius: 15px;
            text-align: center;
        }
        .empty-state i {
            font-size: 4rem;
            color: #ddd;
            margin-bottom: 20px;
        }
        .requirement-alert {
            background: linear-gradient(135deg, #f093fb 0%, #f5576c 100%);
            color: white;
            padding: 20px;
            border-radius: 15px;
            margin-bottom: 30px;
        }
        .requirement-alert h4 {
            margin: 0 0 10px 0;
            font-weight: 600;
        }
    </style>
</head>
<body>
    <?= view('seller/sidebar') ?>

    <div class="content-wrapper">
        <!-- Header -->
        <div class="page-header">
            <h1><i class="bi bi-award"></i> Brand Management</h1>
            <p class="text-muted mb-0">Create and manage your brands (Requires 25+ Reliability Score)</p>
        </div>

        <?php if (($user['seller_reliability_score'] ?? 0) < 25): ?>
            <!-- Requirement Alert (S13, S14) -->
            <div class="requirement-alert">
                <h4><i class="bi bi-lock-fill"></i> Brand Creation Locked</h4>
                <p class="mb-0">
                    You need a seller reliability score of 25 or higher to create brands.
                    Current Score: <strong><?= number_format($user['seller_reliability_score'] ?? 0, 1) ?></strong>
                    | Required: <strong>25.0</strong>
                </p>
                <p class="mb-0 mt-2">
                    <small>Complete more successful transactions to increase your reliability score!</small>
                </p>
            </div>
        <?php else: ?>
            <!-- Stats Cards -->
            <div class="stats-cards">
                <div class="stat-card">
                    <h3><?= count($brands ?? []) ?></h3>
                    <p><i class="bi bi-award-fill"></i> Total Brands</p>
                </div>
                <div class="stat-card" style="background: linear-gradient(135deg, #11998e 0%, #38ef7d 100%);">
                    <h3><?= $total_products ?? 0 ?></h3>
                    <p><i class="bi bi-box-seam"></i> Products with Brands</p>
                </div>
                <div class="stat-card" style="background: linear-gradient(135deg, #f093fb 0%, #f5576c 100%);">
                    <h3><?= number_format($user['seller_reliability_score'] ?? 0, 1) ?></h3>
                    <p><i class="bi bi-star-fill"></i> Your Reliability Score</p>
                </div>
            </div>

            <!-- Create New Brand Button -->
            <div class="mb-4">
                <button class="btn btn-gradient btn-lg" data-bs-toggle="modal" data-bs-target="#createBrandModal">
                    <i class="bi bi-plus-circle"></i> Create New Brand
                </button>
            </div>

            <!-- Brands List -->
            <?php if (empty($brands)): ?>
                <div class="empty-state">
                    <i class="bi bi-award"></i>
                    <h4>No Brands Yet</h4>
                    <p class="text-muted">Create your first brand to start building your identity</p>
                    <button class="btn btn-gradient" data-bs-toggle="modal" data-bs-target="#createBrandModal">
                        <i class="bi bi-plus-circle"></i> Create Brand
                    </button>
                </div>
            <?php else: ?>
                <?php foreach ($brands as $brand): ?>
                    <div class="brand-card">
                        <div class="brand-header">
                            <div>
                                <h3 class="brand-name">
                                    <i class="bi bi-award-fill" style="color: #ffd700;"></i>
                                    <?= esc($brand['brand_name']) ?>
                                </h3>
                            </div>
                            <div>
                                <button class="btn btn-edit me-2" onclick="editBrand(<?= $brand['id'] ?>, '<?= esc($brand['brand_name']) ?>')">
                                    <i class="bi bi-pencil"></i> Edit
                                </button>
                                <button class="btn btn-delete" onclick="deleteBrand(<?= $brand['id'] ?>)">
                                    <i class="bi bi-trash"></i> Delete
                                </button>
                            </div>
                        </div>

                        <div class="brand-meta">
                            <i class="bi bi-calendar"></i>
                            Created: <?= date('d M Y', strtotime($brand['created_at'])) ?>
                        </div>

                        <div class="brand-meta">
                            <i class="bi bi-box-seam"></i>
                            Products: <strong><?= $brand['product_count'] ?? 0 ?></strong>
                        </div>

                        <?php if (!empty($brand['description'])): ?>
                            <div class="mt-3">
                                <p class="text-muted mb-0"><?= esc($brand['description']) ?></p>
                            </div>
                        <?php endif; ?>
                    </div>
                <?php endforeach; ?>
            <?php endif; ?>
        <?php endif; ?>
    </div>

    <!-- Create Brand Modal -->
    <div class="modal fade" id="createBrandModal" tabindex="-1">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Create New Brand</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>
                <form id="createBrandForm">
                    <div class="modal-body">
                        <div class="mb-3">
                            <label class="form-label">Brand Name *</label>
                            <input type="text" class="form-control" name="brand_name" required maxlength="100">
                            <small class="text-muted">Choose a unique name for your brand</small>
                        </div>
                        <div class="mb-3">
                            <label class="form-label">Description (Optional)</label>
                            <textarea class="form-control" name="description" rows="3" maxlength="500"></textarea>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                        <button type="submit" class="btn btn-gradient">Create Brand</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <!-- Edit Brand Modal -->
    <div class="modal fade" id="editBrandModal" tabindex="-1">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Edit Brand</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>
                <form id="editBrandForm">
                    <input type="hidden" name="brand_id" id="edit_brand_id">
                    <div class="modal-body">
                        <div class="mb-3">
                            <label class="form-label">Brand Name *</label>
                            <input type="text" class="form-control" name="brand_name" id="edit_brand_name" required>
                        </div>
                        <div class="mb-3">
                            <label class="form-label">Description</label>
                            <textarea class="form-control" name="description" id="edit_description" rows="3"></textarea>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                        <button type="submit" class="btn btn-gradient">Update Brand</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
    <script>
        // Create Brand
        document.getElementById('createBrandForm').addEventListener('submit', function(e) {
            e.preventDefault();
            
            const formData = new FormData(this);
            
            fetch('/seller/create-brand', {
                method: 'POST',
                body: formData
            })
            .then(response => response.json())
            .then(data => {
                if (data.success) {
                    alert('Brand created successfully!');
                    location.reload();
                } else {
                    alert(data.message || 'Failed to create brand');
                }
            })
            .catch(error => {
                console.error('Error:', error);
                alert('An error occurred');
            });
        });

        // Edit Brand
        function editBrand(id, name) {
            document.getElementById('edit_brand_id').value = id;
            document.getElementById('edit_brand_name').value = name;
            new bootstrap.Modal(document.getElementById('editBrandModal')).show();
        }

        document.getElementById('editBrandForm').addEventListener('submit', function(e) {
            e.preventDefault();
            
            const formData = new FormData(this);
            
            fetch('/seller/update-brand', {
                method: 'POST',
                body: formData
            })
            .then(response => response.json())
            .then(data => {
                if (data.success) {
                    alert('Brand updated successfully!');
                    location.reload();
                } else {
                    alert(data.message || 'Failed to update brand');
                }
            })
            .catch(error => {
                console.error('Error:', error);
                alert('An error occurred');
            });
        });

        // Delete Brand
        function deleteBrand(id) {
            if (!confirm('Are you sure you want to delete this brand? This action cannot be undone.')) {
                return;
            }

            fetch('/seller/delete-brand/' + id, {
                method: 'POST'
            })
            .then(response => response.json())
            .then(data => {
                if (data.success) {
                    alert('Brand deleted successfully');
                    location.reload();
                } else {
                    alert(data.message || 'Failed to delete brand');
                }
            })
            .catch(error => {
                console.error('Error:', error);
                alert('An error occurred');
            });
        }
    </script>
</body>
</html>
