<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Seller Dashboard - Flex Market</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.css">
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <style>
        * {
            font-family: 'Poppins', sans-serif;
        }
        .sidebar {
            min-height: 100vh;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
        }
        .sidebar .nav-link {
            color: rgba(255,255,255,0.8);
            padding: 12px 20px;
            border-radius: 8px;
            margin: 5px 0;
        }
        .sidebar .nav-link:hover, .sidebar .nav-link.active {
            background: rgba(255,255,255,0.2);
            color: #fff;
        }
        .stat-card {
            border-radius: 15px;
            padding: 20px;
            border: none;
            box-shadow: 0 4px 6px rgba(0,0,0,0.1);
        }
        .reliability-badge {
            background: linear-gradient(135deg, #f093fb 0%, #f5576c 100%);
            color: white;
            padding: 8px 16px;
            border-radius: 20px;
            font-weight: 600;
        }
    </style>
</head>
<body class="bg-light">
    <div class="container-fluid">
        <div class="row">
            <!-- Sidebar -->
            <div class="col-md-3 col-lg-2 sidebar text-white p-4">
                <h4 class="mb-4"><i class="bi bi-shop"></i> Flex Market</h4>
                <div class="mb-4">
                    <h6><?= esc($user['name']) ?></h6>
                    <small>Seller Account</small>
                    <div class="mt-2">
                        <span class="reliability-badge">
                            <i class="bi bi-star-fill"></i> <?= $user['reliability_score'] ?? 0 ?> Points
                        </span>
                    </div>
                </div>
                <ul class="nav flex-column">
                    <li class="nav-item">
                        <a class="nav-link active" href="<?= base_url('seller/dashboard') ?>">
                            <i class="bi bi-speedometer2"></i> Dashboard
                        </a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="<?= base_url('seller/upload') ?>">
                            <i class="bi bi-upload"></i> Upload Product
                        </a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="<?= base_url('seller/products') ?>">
                            <i class="bi bi-box-seam"></i> My Products
                        </a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="<?= base_url('seller/offers') ?>">
                            <i class="bi bi-tag"></i> Offers
                            <?php if (count($pending_offers) > 0): ?>
                                <span class="badge bg-danger"><?= count($pending_offers) ?></span>
                            <?php endif; ?>
                        </a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="<?= base_url('seller/orders') ?>">
                            <i class="bi bi-cart-check"></i> Orders
                        </a>
                    </li>
                    <?php if (count($brands) > 0 || ($user['reliability_score'] ?? 0) >= 25): ?>
                    <li class="nav-item">
                        <a class="nav-link" href="#" data-bs-toggle="modal" data-bs-target="#brandModal">
                            <i class="bi bi-award"></i> My Brands
                        </a>
                    </li>
                    <?php endif; ?>
                    <li class="nav-item mt-3">
                        <a class="nav-link" href="<?= base_url('auth/logout') ?>">
                            <i class="bi bi-box-arrow-right"></i> Logout
                        </a>
                    </li>
                </ul>
            </div>

            <!-- Main Content -->
            <div class="col-md-9 col-lg-10 p-4">
                <div class="d-flex justify-content-between align-items-center mb-4">
                    <h2>Welcome, <?= esc($user['name']) ?>!</h2>
                    <div>
                        <a href="<?= base_url('seller/upload') ?>" class="btn btn-primary">
                            <i class="bi bi-plus-circle"></i> Upload New Product
                        </a>
                    </div>
                </div>

                <!-- Stats Cards -->
                <div class="row g-4 mb-4">
                    <div class="col-md-3">
                        <div class="card stat-card bg-primary text-white">
                            <h3><?= count($products) ?></h3>
                            <p class="mb-0"><i class="bi bi-box-seam"></i> Total Products</p>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="card stat-card bg-warning text-white">
                            <h3><?= count(array_filter($products, fn($p) => $p['status'] === 'pending')) ?></h3>
                            <p class="mb-0"><i class="bi bi-clock"></i> Pending Approval</p>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="card stat-card bg-info text-white">
                            <h3><?= count($pending_offers) ?></h3>
                            <p class="mb-0"><i class="bi bi-tag"></i> New Offers</p>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="card stat-card bg-success text-white">
                            <h3><?= count($active_orders) ?></h3>
                            <p class="mb-0"><i class="bi bi-cart-check"></i> Active Orders</p>
                        </div>
                    </div>
                </div>

                <!-- Recent Products -->
                <div class="card mb-4">
                    <div class="card-header bg-white">
                        <h5 class="mb-0">Recent Products</h5>
                    </div>
                    <div class="card-body">
                        <?php if (count($products) > 0): ?>
                            <div class="table-responsive">
                                <table class="table table-hover">
                                    <thead>
                                        <tr>
                                            <th>Product</th>
                                            <th>Type</th>
                                            <th>Price</th>
                                            <th>Status</th>
                                            <th>Offers</th>
                                            <th>Uploaded</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php foreach (array_slice($products, 0, 5) as $product): ?>
                                            <tr>
                                                <td>
                                                    <strong><?= esc($product['title']) ?></strong><br>
                                                    <small class="text-muted"><?= esc($product['category']) ?></small>
                                                </td>
                                                <td>
                                                    <span class="badge bg-<?= $product['listing_type'] === 'sell' ? 'primary' : 'info' ?>">
                                                        <?= ucfirst($product['listing_type']) ?>
                                                    </span>
                                                </td>
                                                <td>₹<?= number_format($product['price'], 2) ?></td>
                                                <td>
                                                    <?php
                                                        $statusColors = [
                                                            'pending' => 'warning',
                                                            'approved' => 'success',
                                                            'rejected' => 'danger',
                                                            'sold' => 'secondary'
                                                        ];
                                                        $color = $statusColors[$product['status']] ?? 'secondary';
                                                    ?>
                                                    <span class="badge bg-<?= $color ?>">
                                                        <?= ucfirst($product['status']) ?>
                                                    </span>
                                                </td>
                                                <td>
                                                    <?php if ($product['offer_count'] > 0): ?>
                                                        <span class="badge bg-info"><?= $product['offer_count'] ?> offers</span>
                                                    <?php else: ?>
                                                        <span class="text-muted">No offers</span>
                                                    <?php endif; ?>
                                                </td>
                                                <td><?= date('d M Y', strtotime($product['created_at'])) ?></td>
                                            </tr>
                                        <?php endforeach; ?>
                                    </tbody>
                                </table>
                            </div>
                            <a href="<?= base_url('seller/products') ?>" class="btn btn-outline-primary btn-sm">View All Products</a>
                        <?php else: ?>
                            <div class="text-center py-5">
                                <i class="bi bi-box-seam" style="font-size: 4rem; color: #ddd;"></i>
                                <h5 class="mt-3 text-muted">No products yet</h5>
                                <p class="text-muted">Start by uploading your first product!</p>
                                <a href="<?= base_url('seller/upload') ?>" class="btn btn-primary">Upload Product</a>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>

                <!-- Pending Offers -->
                <?php if (count($pending_offers) > 0): ?>
                <div class="card">
                    <div class="card-header bg-white">
                        <h5 class="mb-0">Pending Offers</h5>
                    </div>
                    <div class="card-body">
                        <div class="table-responsive">
                            <table class="table table-hover">
                                <thead>
                                    <tr>
                                        <th>Product</th>
                                        <th>Buyer</th>
                                        <th>Buyer Rating</th>
                                        <th>Offer Price</th>
                                        <th>Original Price</th>
                                        <th>Actions</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php foreach (array_slice($pending_offers, 0, 5) as $offer): ?>
                                        <tr>
                                            <td><?= esc($offer['product_title']) ?></td>
                                            <td>
                                                <?= esc($offer['buyer_name']) ?><br>
                                                <small class="text-muted"><?= esc($offer['buyer_mobile']) ?></small>
                                            </td>
                                            <td>
                                                <span class="text-warning">
                                                    <?php 
                                                        $rating = round($offer['buyer_rating']);
                                                        for ($i = 0; $i < 5; $i++) {
                                                            echo $i < $rating ? '<i class="bi bi-star-fill"></i>' : '<i class="bi bi-star"></i>';
                                                        }
                                                    ?>
                                                </span>
                                            </td>
                                            <td class="fw-bold">₹<?= number_format($offer['offer_price'], 2) ?></td>
                                            <td>₹<?= number_format($offer['price'], 2) ?></td>
                                            <td>
                                                <button class="btn btn-success btn-sm" onclick="acceptOffer(<?= $offer['id'] ?>)">
                                                    <i class="bi bi-check-circle"></i> Accept
                                                </button>
                                                <button class="btn btn-danger btn-sm" onclick="rejectOffer(<?= $offer['id'] ?>)">
                                                    <i class="bi bi-x-circle"></i> Reject
                                                </button>
                                            </td>
                                        </tr>
                                    <?php endforeach; ?>
                                </tbody>
                            </table>
                        </div>
                        <a href="<?= base_url('seller/offers') ?>" class="btn btn-outline-primary btn-sm">View All Offers</a>
                    </div>
                </div>
                <?php endif; ?>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
    <script>
        function acceptOffer(offerId) {
            if (confirm('Accept this offer?')) {
                fetch(`/seller/accept-offer/${offerId}`, {
                    method: 'POST',
                    headers: {
                        'Content-Type': 'application/json',
                        'X-Requested-With': 'XMLHttpRequest'
                    }
                })
                .then(res => res.json())
                .then(data => {
                    alert(data.message);
                    location.reload();
                });
            }
        }

        function rejectOffer(offerId) {
            const reason = prompt('Reason for rejection (optional):');
            if (reason !== null) {
                fetch(`/seller/reject-offer/${offerId}`, {
                    method: 'POST',
                    headers: {
                        'Content-Type': 'application/json',
                        'X-Requested-With': 'XMLHttpRequest'
                    },
                    body: JSON.stringify({ remarks: reason })
                })
                .then(res => res.json())
                .then(data => {
                    alert(data.message);
                    location.reload();
                });
            }
        }
    </script>
</body>
</html>
