<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>My Products - Seller</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.css">
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <style>
        * {
            font-family: 'Poppins', sans-serif;
        }
    </style>
</head>
<body class="bg-light">
    <div class="container-fluid p-4">
        <div class="d-flex justify-content-between align-items-center mb-4">
            <h2><i class="bi bi-box-seam"></i> My Products</h2>
            <div>
                <a href="<?= base_url('seller/upload') ?>" class="btn btn-primary">
                    <i class="bi bi-plus-circle"></i> Upload New Product
                </a>
                <a href="<?= base_url('seller/dashboard') ?>" class="btn btn-outline-secondary">
                    <i class="bi bi-arrow-left"></i> Dashboard
                </a>
            </div>
        </div>

        <!-- Filter Tabs -->
        <ul class="nav nav-tabs mb-4">
            <li class="nav-item">
                <a class="nav-link <?= !$current_status ? 'active' : '' ?>" href="<?= base_url('seller/products') ?>">All</a>
            </li>
            <li class="nav-item">
                <a class="nav-link <?= $current_status === 'pending' ? 'active' : '' ?>" href="<?= base_url('seller/products?status=pending') ?>">Pending</a>
            </li>
            <li class="nav-item">
                <a class="nav-link <?= $current_status === 'approved' ? 'active' : '' ?>" href="<?= base_url('seller/products?status=approved') ?>">Approved</a>
            </li>
            <li class="nav-item">
                <a class="nav-link <?= $current_status === 'rejected' ? 'active' : '' ?>" href="<?= base_url('seller/products?status=rejected') ?>">Rejected</a>
            </li>
            <li class="nav-item">
                <a class="nav-link <?= $current_status === 'sold' ? 'active' : '' ?>" href="<?= base_url('seller/products?status=sold') ?>">Sold</a>
            </li>
        </ul>

        <?php if (count($products) > 0): ?>
            <div class="table-responsive">
                <table class="table table-hover bg-white">
                    <thead>
                        <tr>
                            <th>Product</th>
                            <th>Type</th>
                            <th>Price</th>
                            <th>Status</th>
                            <th>Views</th>
                            <th>Offers</th>
                            <th>Images</th>
                            <th>Uploaded</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($products as $product): ?>
                            <tr>
                                <td>
                                    <strong><?= esc($product['title']) ?></strong><br>
                                    <small class="text-muted"><?= esc($product['category']) ?></small>
                                </td>
                                <td>
                                    <span class="badge bg-<?= $product['listing_type'] === 'sell' ? 'primary' : 'info' ?>">
                                        <?= ucfirst($product['listing_type']) ?>
                                    </span>
                                </td>
                                <td>₹<?= number_format($product['price'], 2) ?></td>
                                <td>
                                    <?php
                                        $statusColors = [
                                            'pending' => 'warning',
                                            'approved' => 'success',
                                            'rejected' => 'danger',
                                            'sold' => 'secondary'
                                        ];
                                        $color = $statusColors[$product['status']] ?? 'secondary';
                                    ?>
                                    <span class="badge bg-<?= $color ?>">
                                        <?= ucfirst($product['status']) ?>
                                    </span>
                                    <?php if ($product['status'] === 'rejected' && !empty($product['admin_remarks'])): ?>
                                        <br><small class="text-danger"><?= esc($product['admin_remarks']) ?></small>
                                    <?php endif; ?>
                                </td>
                                <td><?= $product['views_count'] ?></td>
                                <td>
                                    <?php if ($product['offer_count'] > 0): ?>
                                        <a href="<?= base_url('seller/offers') ?>" class="badge bg-info text-decoration-none">
                                            <?= $product['offer_count'] ?> offers
                                        </a>
                                    <?php else: ?>
                                        <span class="text-muted">0</span>
                                    <?php endif; ?>
                                </td>
                                <td><?= $product['image_count'] ?></td>
                                <td><?= date('d M Y', strtotime($product['created_at'])) ?></td>
                                <td>
                                    <button class="btn btn-sm btn-outline-info" onclick="viewProduct(<?= $product['id'] ?>)">
                                        <i class="bi bi-eye"></i> View
                                    </button>
                                </td>
                            </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
        <?php else: ?>
            <div class="text-center py-5 bg-white rounded">
                <i class="bi bi-inbox" style="font-size: 4rem; color: #ddd;"></i>
                <h5 class="mt-3 text-muted">
                    <?php if ($current_status): ?>
                        No <?= $current_status ?> products found
                    <?php else: ?>
                        No products uploaded yet
                    <?php endif; ?>
                </h5>
                <a href="<?= base_url('seller/upload') ?>" class="btn btn-primary mt-3">
                    <i class="bi bi-upload"></i> Upload Your First Product
                </a>
            </div>
        <?php endif; ?>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
    <script>
        function viewProduct(productId) {
            alert('Product details view coming soon!\nProduct ID: ' + productId);
        }
    </script>
</body>
</html>
