<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>My Products - Flex Market</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.css">
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <style>
        * { font-family: 'Poppins', sans-serif; }
        body { background: #f5f5f5; }
        .sidebar { min-height: 100vh; background: linear-gradient(180deg, #9c27b0 0%, #673ab7 100%); box-shadow: 2px 0 10px rgba(0,0,0,0.1); }
        .sidebar .nav-link { color: rgba(255,255,255,0.85); padding: 14px 20px; border-radius: 10px; margin: 6px 0; transition: all 0.3s; }
        .sidebar .nav-link:hover, .sidebar .nav-link.active { background: rgba(255,255,255,0.15); color: #fff; transform: translateX(5px); }
        .sidebar .nav-link i { margin-right: 10px; width: 20px; }
        .product-card { background: white; border-radius: 15px; overflow: hidden; box-shadow: 0 2px 15px rgba(0,0,0,0.08); transition: transform 0.3s; }
        .product-card:hover { transform: translateY(-5px); box-shadow: 0 5px 25px rgba(0,0,0,0.12); }
        .product-image { width: 100%; height: 200px; object-fit: cover; }
        .status-badge { padding: 6px 12px; border-radius: 20px; font-size: 12px; font-weight: 600; }
        .status-approved { background: #d4edda; color: #155724; }
        .status-pending { background: #fff3cd; color: #856404; }
        .status-rejected { background: #f8d7da; color: #721c24; }
        .filter-card { background: white; border-radius: 15px; padding: 20px; box-shadow: 0 2px 15px rgba(0,0,0,0.08); margin-bottom: 20px; }
    </style>
</head>
<body>
    <div class="container-fluid">
        <div class="row">
            <?php include 'sidebar.php'; ?>

            <div class="col-md-9 col-lg-10 p-4">
                <div class="d-flex justify-content-between align-items-center mb-4">
                    <div>
                        <h2><i class="bi bi-box-seam"></i> My Products</h2>
                        <p class="text-muted mb-0">Manage your uploaded products</p>
                    </div>
                    <a href="<?= base_url('seller/upload') ?>" class="btn btn-primary">
                        <i class="bi bi-cloud-upload"></i> Upload New
                    </a>
                </div>

                <!-- Filters -->
                <div class="filter-card">
                    <form method="get" class="row g-3">
                        <div class="col-md-3">
                            <label class="form-label">Status</label>
                            <select class="form-select" name="status">
                                <option value="">All Products</option>
                                <option value="approved" <?= ($status ?? '') === 'approved' ? 'selected' : '' ?>>Approved</option>
                                <option value="pending" <?= ($status ?? '') === 'pending' ? 'selected' : '' ?>>Pending</option>
                                <option value="rejected" <?= ($status ?? '') === 'rejected' ? 'selected' : '' ?>>Rejected</option>
                            </select>
                        </div>
                        <div class="col-md-3">
                            <label class="form-label">Type</label>
                            <select class="form-select" name="type">
                                <option value="">All Types</option>
                                <option value="sell">For Sale</option>
                                <option value="rent">For Rent</option>
                            </select>
                        </div>
                        <div class="col-md-3">
                            <label class="form-label">Category</label>
                            <select class="form-select" name="category">
                                <option value="">All Categories</option>
                                <option value="Fashion">Fashion</option>
                                <option value="Electronics">Electronics</option>
                                <option value="Home & Living">Home & Living</option>
                                <option value="Books">Books</option>
                                <option value="Sports">Sports</option>
                            </select>
                        </div>
                        <div class="col-md-3">
                            <label class="form-label">&nbsp;</label>
                            <button type="submit" class="btn btn-primary w-100">
                                <i class="bi bi-funnel"></i> Filter
                            </button>
                        </div>
                    </form>
                </div>

                <!-- Stats -->
                <div class="row g-3 mb-4">
                    <div class="col-md-3">
                        <div class="card text-center" style="border-radius: 15px; border: none; box-shadow: 0 2px 15px rgba(0,0,0,0.08);">
                            <div class="card-body">
                                <h3 class="mb-1"><?= count($products ?? []) ?></h3>
                                <small class="text-muted">Total Products</small>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="card text-center" style="border-radius: 15px; border: none; box-shadow: 0 2px 15px rgba(0,0,0,0.08);">
                            <div class="card-body">
                                <h3 class="mb-1 text-success"><?= count(array_filter($products ?? [], fn($p) => $p['status'] === 'approved')) ?></h3>
                                <small class="text-muted">Approved</small>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="card text-center" style="border-radius: 15px; border: none; box-shadow: 0 2px 15px rgba(0,0,0,0.08);">
                            <div class="card-body">
                                <h3 class="mb-1 text-warning"><?= count(array_filter($products ?? [], fn($p) => $p['status'] === 'pending')) ?></h3>
                                <small class="text-muted">Pending</small>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="card text-center" style="border-radius: 15px; border: none; box-shadow: 0 2px 15px rgba(0,0,0,0.08);">
                            <div class="card-body">
                                <h3 class="mb-1 text-danger"><?= count(array_filter($products ?? [], fn($p) => $p['status'] === 'rejected')) ?></h3>
                                <small class="text-muted">Rejected</small>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Products Grid -->
                <?php if (empty($products)): ?>
                    <div class="text-center py-5">
                        <i class="bi bi-inbox" style="font-size: 64px; color: #ccc;"></i>
                        <h5 class="mt-3 text-muted">No products found</h5>
                        <p class="text-muted">Upload your first product to get started</p>
                        <a href="<?= base_url('seller/upload') ?>" class="btn btn-primary mt-3">
                            <i class="bi bi-cloud-upload"></i> Upload Product
                        </a>
                    </div>
                <?php else: ?>
                    <div class="row g-3">
                        <?php foreach ($products as $product): ?>
                            <div class="col-md-6 col-lg-4">
                                <div class="product-card">
                                    <img src="<?= base_url(esc($product['primary_image'] ?? 'placeholder.jpg')) ?>" alt="Product" class="product-image">
                                    <div class="p-3">
                                        <div class="d-flex justify-content-between align-items-start mb-2">
                                            <h6 class="mb-0"><?= esc($product['title']) ?></h6>
                                            <span class="status-badge status-<?= esc($product['status']) ?>">
                                                <?= ucfirst($product['status']) ?>
                                            </span>
                                        </div>
                                        <p class="text-muted small mb-2"><?= esc($product['category']) ?></p>
                                        <div class="d-flex justify-content-between align-items-center mb-3">
                                            <div>
                                                <?php if ($product['listing_type'] === 'sell'): ?>
                                                    <strong class="text-success">₹<?= number_format($product['price'], 2) ?></strong>
                                                <?php else: ?>
                                                    <strong class="text-info">₹<?= number_format($product['rental_cost'], 2) ?>/day</strong><br>
                                                    <small class="text-muted">Deposit: ₹<?= number_format($product['rental_deposit'], 2) ?></small>
                                                <?php endif; ?>
                                            </div>
                                            <span class="badge <?= $product['listing_type'] === 'sell' ? 'bg-success' : 'bg-info' ?>">
                                                <?= ucfirst($product['listing_type']) ?>
                                            </span>
                                        </div>
                                        <div class="d-grid gap-2">
                                            <button class="btn btn-sm btn-outline-primary" onclick="viewProduct(<?= $product['id'] ?>)">
                                                <i class="bi bi-eye"></i> View Details
                                            </button>
                                            <?php if ($product['status'] === 'approved'): ?>
                                                <button class="btn btn-sm btn-outline-secondary" onclick="editProduct(<?= $product['id'] ?>)">
                                                    <i class="bi bi-pencil"></i> Edit
                                                </button>
                                            <?php endif; ?>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        <?php endforeach; ?>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
    <script>
        function viewProduct(id) {
            window.location.href = '/seller/product/' + id;
        }
        function editProduct(id) {
            window.location.href = '/seller/edit-product/' + id;
        }
    </script>
</body>
</html>
