<!-- Seller Sidebar -->
<div class="col-md-3 col-lg-2 px-0 sidebar">
    <div class="p-3">
        <div class="text-white mb-4">
            <h5 class="mb-1">
                <i class="bi bi-person-circle"></i> <?= esc(session()->get('name') ?? 'Seller') ?>
            </h5>
            <small class="opacity-75"><?= esc(session()->get('email')) ?></small>
            <div class="mt-2">
                <span class="badge bg-light text-dark">
                    <i class="bi bi-star-fill text-warning"></i> 
                    <?= number_format($user['seller_reliability_score'] ?? 0, 1) ?> Seller
                </span>
                <?php if (($user['subscription_tier'] ?? 'free') != 'free'): ?>
                    <span class="badge bg-warning text-dark">
                        <?= ucfirst($user['subscription_tier'] ?? 'free') ?> Plan
                    </span>
                <?php endif; ?>
            </div>
        </div>

        <nav class="nav flex-column">
            <a href="<?= base_url('seller/dashboard') ?>" class="nav-link <?= (uri_string() == 'seller/dashboard' || uri_string() == 'seller') ? 'active' : '' ?>">
                <i class="bi bi-speedometer2"></i> Dashboard
            </a>
            <a href="<?= base_url('seller/upload') ?>" class="nav-link <?= uri_string() == 'seller/upload' ? 'active' : '' ?>">
                <i class="bi bi-cloud-upload"></i> Upload Product
            </a>
            <a href="<?= base_url('seller/products') ?>" class="nav-link <?= uri_string() == 'seller/products' ? 'active' : '' ?>">
                <i class="bi bi-box-seam"></i> My Products
            </a>
            <a href="<?= base_url('seller/offers') ?>" class="nav-link <?= uri_string() == 'seller/offers' ? 'active' : '' ?>">
                <i class="bi bi-chat-left-text"></i> Offers
                <?php 
                    $offerModel = new \App\Models\OfferModel();
                    $pendingCount = $offerModel->where('seller_id', session()->get('id'))
                                                ->where('status', 'pending')
                                                ->countAllResults();
                    if ($pendingCount > 0):
                ?>
                    <span class="badge bg-danger rounded-pill float-end"><?= $pendingCount ?></span>
                <?php endif; ?>
            </a>
            <a href="<?= base_url('seller/orders') ?>" class="nav-link <?= uri_string() == 'seller/orders' ? 'active' : '' ?>">
                <i class="bi bi-receipt"></i> Orders
            </a>
            <a href="<?= base_url('seller/transactions') ?>" class="nav-link <?= uri_string() == 'seller/transactions' ? 'active' : '' ?>">
                <i class="bi bi-cash-stack"></i> Transactions
            </a>
            <a href="<?= base_url('seller/brands') ?>" class="nav-link <?= uri_string() == 'seller/brands' ? 'active' : '' ?>">
                <i class="bi bi-award"></i> My Brands
                <?php if (($user['seller_reliability_score'] ?? 0) < 25): ?>
                    <i class="bi bi-lock-fill float-end" title="Unlock at 25 reliability"></i>
                <?php endif; ?>
            </a>
            <a href="<?= base_url('seller/subscription') ?>" class="nav-link <?= uri_string() == 'seller/subscription' ? 'active' : '' ?>">
                <i class="bi bi-gem"></i> Subscription
            </a>
            <a href="<?= base_url('seller/profile') ?>" class="nav-link <?= uri_string() == 'seller/profile' ? 'active' : '' ?>">
                <i class="bi bi-person-gear"></i> Profile
            </a>
            
            <hr class="bg-white opacity-25 my-3">
            
            <a href="<?= base_url('seller/notifications') ?>" class="nav-link <?= uri_string() == 'seller/notifications' ? 'active' : '' ?>">
                <i class="bi bi-bell"></i> Notifications
                <?php 
                    $notifModel = new \App\Models\NotificationModel();
                    $unreadCount = $notifModel->where('user_id', session()->get('id'))
                                              ->where('is_read', 0)
                                              ->countAllResults();
                    if ($unreadCount > 0):
                ?>
                    <span class="badge bg-danger rounded-pill float-end"><?= $unreadCount ?></span>
                <?php endif; ?>
            </a>
            <a href="<?= base_url('seller/help') ?>" class="nav-link <?= uri_string() == 'seller/help' ? 'active' : '' ?>">
                <i class="bi bi-question-circle"></i> Help & Support
            </a>
            <a href="<?= base_url('auth/logout') ?>" class="nav-link text-danger">
                <i class="bi bi-box-arrow-right"></i> Logout
            </a>
        </nav>
    </div>
</div>
