<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Transactions - Flex Market</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.css">
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <style>
        * { font-family: 'Poppins', sans-serif; }
        body { background: #f5f5f5; }
        .sidebar {
            min-height: 100vh;
            background: linear-gradient(180deg, #9c27b0 0%, #673ab7 100%);
            box-shadow: 2px 0 10px rgba(0,0,0,0.1);
        }
        .sidebar .nav-link {
            color: rgba(255,255,255,0.85);
            padding: 14px 20px;
            border-radius: 10px;
            margin: 6px 0;
            transition: all 0.3s;
        }
        .sidebar .nav-link:hover, .sidebar .nav-link.active {
            background: rgba(255,255,255,0.15);
            color: #fff;
            transform: translateX(5px);
        }
        .sidebar .nav-link i { margin-right: 10px; width: 20px; }
        .transaction-card {
            background: white;
            border-radius: 15px;
            padding: 20px;
            box-shadow: 0 2px 15px rgba(0,0,0,0.08);
            margin-bottom: 15px;
            transition: transform 0.3s;
        }
        .transaction-card:hover {
            transform: translateY(-3px);
            box-shadow: 0 5px 25px rgba(0,0,0,0.12);
        }
        .status-badge {
            padding: 6px 12px;
            border-radius: 20px;
            font-size: 12px;
            font-weight: 600;
        }
        .status-completed { background: #d4edda; color: #155724; }
        .status-pending { background: #fff3cd; color: #856404; }
        .status-cancelled { background: #f8d7da; color: #721c24; }
        .status-dispatched { background: #d1ecf1; color: #0c5460; }
        .status-returned { background: #e2e3e5; color: #383d41; }
        .timeline {
            position: relative;
            padding-left: 30px;
        }
        .timeline::before {
            content: '';
            position: absolute;
            left: 8px;
            top: 0;
            height: 100%;
            width: 2px;
            background: #dee2e6;
        }
        .timeline-item {
            position: relative;
            padding-bottom: 15px;
        }
        .timeline-item::before {
            content: '';
            position: absolute;
            left: -25px;
            top: 5px;
            width: 12px;
            height: 12px;
            border-radius: 50%;
            background: #667eea;
            border: 2px solid white;
        }
    </style>
</head>
<body>
    <div class="container-fluid">
        <div class="row">
            <?php include 'sidebar.php'; ?>

            <!-- Main Content -->
            <div class="col-md-9 col-lg-10 p-4">
                <div class="d-flex justify-content-between align-items-center mb-4">
                    <div>
                        <h2><i class="bi bi-cash-stack"></i> Transaction History</h2>
                        <p class="text-muted mb-0">All your sales and rental transactions</p>
                    </div>
                </div>

                <!-- Filters -->
                <div class="card mb-4" style="border-radius: 15px; box-shadow: 0 2px 15px rgba(0,0,0,0.08);">
                    <div class="card-body">
                        <form method="get" class="row g-3">
                            <div class="col-md-3">
                                <label class="form-label">Transaction Type</label>
                                <select class="form-select" name="type">
                                    <option value="">All Types</option>
                                    <option value="sale">Sale</option>
                                    <option value="rental">Rental</option>
                                </select>
                            </div>
                            <div class="col-md-3">
                                <label class="form-label">Status</label>
                                <select class="form-select" name="status">
                                    <option value="">All Status</option>
                                    <option value="completed">Completed</option>
                                    <option value="pending">Pending</option>
                                    <option value="dispatched">Dispatched</option>
                                    <option value="returned">Returned</option>
                                    <option value="cancelled">Cancelled</option>
                                </select>
                            </div>
                            <div class="col-md-3">
                                <label class="form-label">From Date</label>
                                <input type="date" class="form-control" name="from_date">
                            </div>
                            <div class="col-md-3">
                                <label class="form-label">&nbsp;</label>
                                <button type="submit" class="btn btn-primary w-100">
                                    <i class="bi bi-funnel"></i> Filter
                                </button>
                            </div>
                        </form>
                    </div>
                </div>

                <!-- Transaction List -->
                <?php if (empty($transactions)): ?>
                    <div class="text-center py-5">
                        <i class="bi bi-inbox" style="font-size: 64px; color: #ccc;"></i>
                        <h5 class="mt-3 text-muted">No transactions yet</h5>
                        <p class="text-muted">Your sales and rentals will appear here</p>
                        <a href="<?= base_url('seller/upload') ?>" class="btn btn-primary mt-3">
                            <i class="bi bi-cloud-upload"></i> Upload First Product
                        </a>
                    </div>
                <?php else: ?>
                    <?php foreach ($transactions as $transaction): ?>
                        <div class="transaction-card">
                            <div class="row">
                                <div class="col-md-8">
                                    <div class="d-flex align-items-start">
                                        <div class="flex-shrink-0 me-3">
                                            <img src="<?= base_url(esc($transaction['product_image'] ?? 'placeholder.jpg')) ?>" 
                                                 alt="Product" style="width: 80px; height: 80px; object-fit: cover; border-radius: 10px;">
                                        </div>
                                        <div class="flex-grow-1">
                                            <div class="d-flex justify-content-between align-items-start mb-2">
                                                <div>
                                                    <h5 class="mb-1"><?= esc($transaction['product_title']) ?></h5>
                                                    <span class="badge <?= $transaction['type'] === 'sale' ? 'bg-success' : 'bg-info' ?>">
                                                        <?= ucfirst($transaction['type']) ?>
                                                    </span>
                                                </div>
                                                <span class="status-badge status-<?= esc($transaction['status']) ?>">
                                                    <?= ucfirst($transaction['status']) ?>
                                                </span>
                                            </div>
                                            <p class="text-muted mb-2">
                                                <i class="bi bi-person"></i> Buyer: <?= esc($transaction['buyer_name']) ?><br>
                                                <i class="bi bi-calendar"></i> Order Date: <?= date('d M Y', strtotime($transaction['created_at'])) ?>
                                            </p>
                                            <?php if ($transaction['type'] === 'rental'): ?>
                                                <p class="text-muted mb-0">
                                                    <i class="bi bi-clock-history"></i> 
                                                    Rental Period: <?= date('d M', strtotime($transaction['rental_start_date'])) ?> - 
                                                    <?= date('d M Y', strtotime($transaction['rental_end_date'])) ?>
                                                </p>
                                            <?php endif; ?>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-4 text-end">
                                    <div class="mb-3">
                                        <small class="text-muted d-block">Total Amount</small>
                                        <h4 class="mb-0 text-success">₹<?= number_format($transaction['total_amount'], 2) ?></h4>
                                    </div>
                                    <div class="d-grid gap-2">
                                        <button class="btn btn-sm btn-outline-primary" 
                                                data-bs-toggle="modal" 
                                                data-bs-target="#detailsModal<?= $transaction['id'] ?>">
                                            <i class="bi bi-eye"></i> View Details
                                        </button>
                                        <?php if ($transaction['status'] === 'completed' && !isset($transaction['review_given'])): ?>
                                            <button class="btn btn-sm btn-outline-warning">
                                                <i class="bi bi-star"></i> Rate Buyer
                                            </button>
                                        <?php endif; ?>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- Details Modal -->
                        <div class="modal fade" id="detailsModal<?= $transaction['id'] ?>" tabindex="-1">
                            <div class="modal-dialog modal-lg">
                                <div class="modal-content">
                                    <div class="modal-header">
                                        <h5 class="modal-title">Transaction Details - #<?= $transaction['id'] ?></h5>
                                        <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                                    </div>
                                    <div class="modal-body">
                                        <div class="row mb-4">
                                            <div class="col-md-6">
                                                <h6 class="text-muted">Product Information</h6>
                                                <p><strong>Title:</strong> <?= esc($transaction['product_title']) ?></p>
                                                <p><strong>Category:</strong> <?= esc($transaction['category']) ?></p>
                                                <p><strong>Type:</strong> <?= ucfirst($transaction['type']) ?></p>
                                            </div>
                                            <div class="col-md-6">
                                                <h6 class="text-muted">Buyer Information</h6>
                                                <p><strong>Name:</strong> <?= esc($transaction['buyer_name']) ?></p>
                                                <p><strong>Email:</strong> <?= esc($transaction['buyer_email']) ?></p>
                                                <p><strong>Rating:</strong> 
                                                    <i class="bi bi-star-fill text-warning"></i> <?= number_format($transaction['buyer_rating'], 1) ?>
                                                </p>
                                            </div>
                                        </div>
                                        
                                        <h6 class="text-muted mb-3">Order Timeline</h6>
                                        <div class="timeline">
                                            <?php foreach ($transaction['status_history'] ?? [] as $history): ?>
                                                <div class="timeline-item">
                                                    <strong><?= ucfirst($history['status']) ?></strong><br>
                                                    <small class="text-muted"><?= date('d M Y, h:i A', strtotime($history['created_at'])) ?></small>
                                                    <?php if (!empty($history['notes'])): ?>
                                                        <p class="mb-0 mt-1"><?= esc($history['notes']) ?></p>
                                                    <?php endif; ?>
                                                </div>
                                            <?php endforeach; ?>
                                        </div>

                                        <div class="mt-4 p-3 bg-light rounded">
                                            <div class="row">
                                                <?php if ($transaction['type'] === 'rental'): ?>
                                                    <div class="col-6">
                                                        <p class="mb-1 text-muted">Deposit</p>
                                                        <h6>₹<?= number_format($transaction['deposit_amount'], 2) ?></h6>
                                                    </div>
                                                    <div class="col-6">
                                                        <p class="mb-1 text-muted">Rental Cost</p>
                                                        <h6>₹<?= number_format($transaction['rental_cost'], 2) ?></h6>
                                                    </div>
                                                <?php endif; ?>
                                                <div class="col-12 mt-2 pt-2 border-top">
                                                    <p class="mb-1 text-muted">Total Amount</p>
                                                    <h5 class="text-success mb-0">₹<?= number_format($transaction['total_amount'], 2) ?></h5>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    <?php endforeach; ?>
                <?php endif; ?>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
