<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Manage Admins - Flex Market</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.css">
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <style>
        * { font-family: 'Poppins', sans-serif; }
        body { background: #f5f5f5; }
        .sidebar {
            min-height: 100vh;
            background: linear-gradient(180deg, #1a237e 0%, #0d47a1 100%);
        }
        .sidebar .nav-link {
            color: rgba(255,255,255,0.85);
            padding: 14px 20px;
            border-radius: 10px;
            margin: 6px 0;
        }
        .sidebar .nav-link:hover, .sidebar .nav-link.active {
            background: rgba(255,255,255,0.15);
            color: #fff;
        }
        .sidebar .nav-link i { margin-right: 10px; }
    </style>
</head>
<body>
    <div class="container-fluid">
        <div class="row">
            <!-- Sidebar -->
            <div class="col-md-3 col-lg-2 px-0 sidebar">
                <div class="p-3">
                    <h4 class="text-white mb-4"><i class="bi bi-shield-check"></i> Super Admin</h4>
                    <nav class="nav flex-column">
                        <a href="<?= base_url('superadmin/dashboard') ?>" class="nav-link">
                            <i class="bi bi-speedometer2"></i> Dashboard
                        </a>
                        <a href="<?= base_url('superadmin/users') ?>" class="nav-link">
                            <i class="bi bi-people"></i> Users
                        </a>
                        <a href="<?= base_url('superadmin/admins') ?>" class="nav-link active">
                            <i class="bi bi-person-badge"></i> Admins
                        </a>
                        <a href="<?= base_url('superadmin/settings') ?>" class="nav-link">
                            <i class="bi bi-gear"></i> Settings
                        </a>
                        <a href="<?= base_url('superadmin/reports') ?>" class="nav-link">
                            <i class="bi bi-file-earmark-text"></i> Reports
                        </a>
                        <a href="<?= base_url('auth/logout') ?>" class="nav-link mt-4">
                            <i class="bi bi-box-arrow-right"></i> Logout
                        </a>
                    </nav>
                </div>
            </div>

            <!-- Main Content -->
            <div class="col-md-9 col-lg-10 p-4">
                <div class="d-flex justify-content-between align-items-center mb-4">
                    <h2><i class="bi bi-person-badge"></i> Admin Management</h2>
                    <button class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#createAdminModal">
                        <i class="bi bi-plus-circle"></i> Create Admin
                    </button>
                </div>

                <div class="card border-0 shadow-sm">
                    <div class="card-body">
                        <table class="table table-hover">
                            <thead>
                                <tr>
                                    <th>ID</th>
                                    <th>Name</th>
                                    <th>Email</th>
                                    <th>Mobile</th>
                                    <th>Joined</th>
                                    <th>Status</th>
                                    <th>Action</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php if (!empty($admins)): ?>
                                    <?php foreach ($admins as $admin): ?>
                                        <tr>
                                            <td><?= esc($admin['id']) ?></td>
                                            <td><?= esc($admin['name']) ?></td>
                                            <td><?= esc($admin['email']) ?></td>
                                            <td><?= esc($admin['mobile']) ?></td>
                                            <td><?= date('d M Y', strtotime($admin['created_at'])) ?></td>
                                            <td>
                                                <span class="badge bg-<?= $admin['is_verified'] ? 'success' : 'danger' ?>">
                                                    <?= $admin['is_verified'] ? 'Active' : 'Inactive' ?>
                                                </span>
                                            </td>
                                            <td>
                                                <button onclick="deleteAdmin(<?= $admin['id'] ?>)" class="btn btn-sm btn-danger">
                                                    <i class="bi bi-trash"></i> Delete
                                                </button>
                                            </td>
                                        </tr>
                                    <?php endforeach; ?>
                                <?php else: ?>
                                    <tr>
                                        <td colspan="7" class="text-center text-muted">No admins found</td>
                                    </tr>
                                <?php endif; ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Create Admin Modal -->
    <div class="modal fade" id="createAdminModal" tabindex="-1">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Create New Admin</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>
                <form id="createAdminForm">
                    <div class="modal-body">
                        <div class="mb-3">
                            <label class="form-label">Name</label>
                            <input type="text" name="name" class="form-control" required>
                        </div>
                        <div class="mb-3">
                            <label class="form-label">Email</label>
                            <input type="email" name="email" class="form-control" required>
                        </div>
                        <div class="mb-3">
                            <label class="form-label">Mobile</label>
                            <input type="text" name="mobile" class="form-control" required>
                        </div>
                        <div class="mb-3">
                            <label class="form-label">Password</label>
                            <input type="password" name="password" class="form-control" required>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                        <button type="submit" class="btn btn-primary">Create Admin</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
    <script>
        document.getElementById('createAdminForm').addEventListener('submit', function(e) {
            e.preventDefault();
            const formData = new FormData(this);
            
            fetch('<?= base_url("superadmin/create-admin") ?>', {
                method: 'POST',
                body: formData
            })
            .then(response => response.json())
            .then(data => {
                // Controller returns { success: true/false, message: '' }
                if (data.success || data.status === 'success') {
                    Swal.fire('Success!', data.message || data.msg || 'Admin created', 'success').then(() => {
                        location.reload();
                    });
                } else {
                    Swal.fire('Error!', data.message || data.msg || 'Failed to create admin', 'error');
                }
            })
            .catch(err => {
                console.error(err);
                Swal.fire('Error!', 'Unexpected server response. Check console for details.', 'error');
            });
        });

        function deleteAdmin(adminId) {
            Swal.fire({
                title: 'Are you sure?',
                text: 'This will deactivate the admin account',
                icon: 'warning',
                showCancelButton: true,
                confirmButtonText: 'Yes, delete it!',
                confirmButtonColor: '#dc3545'
            }).then((result) => {
                if (result.isConfirmed) {
                    fetch('<?= base_url("superadmin/delete-admin") ?>/' + adminId, {
                        method: 'POST'
                    })
                    .then(response => response.json())
                    .then(data => {
                        if (data.success || data.status === 'success') {
                            Swal.fire('Deleted!', data.message || 'Admin deactivated', 'success').then(() => {
                                location.reload();
                            });
                        } else {
                            Swal.fire('Error!', data.message || 'Failed to delete admin', 'error');
                        }
                    })
                    .catch(err => {
                        console.error(err);
                        Swal.fire('Error!', 'Unexpected server response. Check console for details.', 'error');
                    });
                }
            });
        }
    </script>
</body>
</html>
