<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>System Settings - Flex Market</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.css">
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <style>
        * { font-family: 'Poppins', sans-serif; }
        body { background: #f5f5f5; }
        .sidebar {
            min-height: 100vh;
            background: linear-gradient(180deg, #1a237e 0%, #0d47a1 100%);
        }
        .sidebar .nav-link {
            color: rgba(255,255,255,0.85);
            padding: 14px 20px;
            border-radius: 10px;
            margin: 6px 0;
        }
        .sidebar .nav-link:hover, .sidebar .nav-link.active {
            background: rgba(255,255,255,0.15);
            color: #fff;
        }
        .sidebar .nav-link i { margin-right: 10px; }
    </style>
</head>
<body>
    <div class="container-fluid">
        <div class="row">
            <!-- Sidebar -->
            <div class="col-md-3 col-lg-2 px-0 sidebar">
                <div class="p-3">
                    <h4 class="text-white mb-4"><i class="bi bi-shield-check"></i> Super Admin</h4>
                    <nav class="nav flex-column">
                        <a href="<?= base_url('superadmin/dashboard') ?>" class="nav-link">
                            <i class="bi bi-speedometer2"></i> Dashboard
                        </a>
                        <a href="<?= base_url('superadmin/users') ?>" class="nav-link">
                            <i class="bi bi-people"></i> Users
                        </a>
                        <a href="<?= base_url('superadmin/admins') ?>" class="nav-link">
                            <i class="bi bi-person-badge"></i> Admins
                        </a>
                        <a href="<?= base_url('superadmin/settings') ?>" class="nav-link active">
                            <i class="bi bi-gear"></i> Settings
                        </a>
                        <a href="<?= base_url('superadmin/reports') ?>" class="nav-link">
                            <i class="bi bi-file-earmark-text"></i> Reports
                        </a>
                        <a href="<?= base_url('auth/logout') ?>" class="nav-link mt-4">
                            <i class="bi bi-box-arrow-right"></i> Logout
                        </a>
                    </nav>
                </div>
            </div>

            <!-- Main Content -->
            <div class="col-md-9 col-lg-10 p-4">
                <h2 class="mb-4"><i class="bi bi-gear"></i> System Settings</h2>

                <div class="card border-0 shadow-sm">
                    <div class="card-body">
                        <form id="settingsForm">
                            <div class="row g-4">
                                <div class="col-md-6">
                                    <label class="form-label">Site Name</label>
                                    <input type="text" name="site_name" class="form-control" 
                                           value="<?= esc($settings['site_name'] ?? 'Flex Market') ?>">
                                </div>
                                
                                <div class="col-md-6">
                                    <label class="form-label">Commission Rate (%)</label>
                                    <input type="number" name="commission_rate" class="form-control" step="0.1"
                                           value="<?= esc($settings['commission_rate'] ?? 10) ?>">
                                    <small class="text-muted">Platform commission on each transaction</small>
                                </div>
                                
                                <div class="col-md-6">
                                    <label class="form-label">Delivery Charge (₹)</label>
                                    <input type="number" name="delivery_charge" class="form-control" 
                                           value="<?= esc($settings['delivery_charge'] ?? 50) ?>">
                                    <small class="text-muted">Fixed delivery charge per order</small>
                                </div>
                                
                                <div class="col-md-6">
                                    <label class="form-label">Minimum Order Value (₹)</label>
                                    <input type="number" name="min_order_value" class="form-control" 
                                           value="<?= esc($settings['min_order_value'] ?? 100) ?>">
                                    <small class="text-muted">Minimum amount for placing orders</small>
                                </div>
                                
                                <div class="col-md-6">
                                    <label class="form-label">Support Email</label>
                                    <input type="email" name="support_email" class="form-control" 
                                           value="<?= esc($settings['support_email'] ?? 'support@flexmarket.com') ?>">
                                </div>
                                
                                <div class="col-md-6">
                                    <label class="form-label">Support Mobile</label>
                                    <input type="text" name="support_mobile" class="form-control" 
                                           value="<?= esc($settings['support_mobile'] ?? '+91-XXXXXXXXXX') ?>">
                                </div>
                                
                                <div class="col-md-12">
                                    <label class="form-label">Maintenance Mode</label>
                                    <div class="form-check form-switch">
                                        <input class="form-check-input" type="checkbox" name="maintenance_mode" 
                                               id="maintenanceMode" <?= (!empty($settings['maintenance_mode'])) ? 'checked' : '' ?>>
                                        <label class="form-check-label" for="maintenanceMode">
                                            Enable maintenance mode (site will be inaccessible to users)
                                        </label>
                                    </div>
                                </div>
                                
                                <div class="col-md-12">
                                    <button type="submit" class="btn btn-primary">
                                        <i class="bi bi-check-circle"></i> Save Settings
                                    </button>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
    <script>
        document.getElementById('settingsForm').addEventListener('submit', function(e) {
            e.preventDefault();
            const formData = new FormData(this);
            
            fetch('/superadmin/update-settings', {
                method: 'POST',
                body: formData
            })
            .then(response => response.json())
            .then(data => {
                if (data.status === 'success') {
                    Swal.fire('Success!', data.message, 'success');
                } else {
                    Swal.fire('Error!', data.message, 'error');
                }
            });
        });
    </script>
</body>
</html>
