-- Flex Market - Create Dummy Users for Testing
-- Run this SQL script to create test users for all roles

-- Clear existing dummy users (optional - comment out if you want to keep existing data)
DELETE FROM users WHERE email IN (
    'superadmin@flex.com',
    'admin@flex.com', 
    'seller@flex.com',
    'delivery@flex.com',
    'buyer@flex.com'
);

-- 1. SUPER ADMIN USER
-- Email: superadmin@flex.com
-- Password: Super@123
INSERT INTO `users` (
    `name`, `email`, `mobile`, `password`, `address`, `pin_code`, 
    `user_type`, `role`, `reliability_score`, `is_blocked`, 
    `is_verified`, `created_at`, `updated_at`
) VALUES (
    'Super Admin',
    'superadmin@flex.com',
    '9999999999',
    '$2y$10$92IXUNpkjO0rOQ5byMi.Ye4oKoEa3Ro9llC/.og/at2.uheWG/igi',
    'Super Admin Office, Main Street',
    '110001',
    'buyer',
    'super_admin',
    100,
    0,
    1,
    NOW(),
    NOW()
);

-- 2. ADMIN USER
-- Email: admin@flex.com
-- Password: Admin@123
INSERT INTO `users` (
    `name`, `email`, `mobile`, `password`, `address`, `pin_code`, 
    `user_type`, `role`, `reliability_score`, `is_blocked`, 
    `is_verified`, `created_at`, `updated_at`
) VALUES (
    'Admin User',
    'admin@flex.com',
    '9888888888',
    '$2y$10$92IXUNpkjO0rOQ5byMi.Ye4oKoEa3Ro9llC/.og/at2.uheWG/igi',
    'Admin Office, Central Avenue',
    '110002',
    'buyer',
    'admin',
    80,
    0,
    1,
    NOW(),
    NOW()
);

-- 3. SELLER USER
-- Email: seller@flex.com
-- Password: Seller@123
INSERT INTO `users` (
    `name`, `email`, `mobile`, `password`, `address`, `pin_code`, 
    `user_type`, `role`, `reliability_score`, `is_blocked`, 
    `is_verified`, `created_at`, `updated_at`
) VALUES (
    'Test Seller',
    'seller@flex.com',
    '9777777777',
    '$2y$10$92IXUNpkjO0rOQ5byMi.Ye4oKoEa3Ro9llC/.og/at2.uheWG/igi',
    'Seller Shop, Market Road',
    '110003',
    'seller',
    'seller',
    60,
    0,
    1,
    NOW(),
    NOW()
);

-- 4. DELIVERY PERSON USER
-- Email: delivery@flex.com
-- Password: Delivery@123
INSERT INTO `users` (
    `name`, `email`, `mobile`, `password`, `address`, `pin_code`, 
    `user_type`, `role`, `reliability_score`, `is_blocked`, 
    `is_verified`, `created_at`, `updated_at`
) VALUES (
    'Delivery Person',
    'delivery@flex.com',
    '9666666666',
    '$2y$10$92IXUNpkjO0rOQ5byMi.Ye4oKoEa3Ro9llC/.og/at2.uheWG/igi',
    'Delivery Hub, Station Road',
    '110004',
    'buyer',
    'delivery',
    70,
    0,
    1,
    NOW(),
    NOW()
);

-- 5. BUYER USER
-- Email: buyer@flex.com
-- Password: Buyer@123
INSERT INTO `users` (
    `name`, `email`, `mobile`, `password`, `address`, `pin_code`, 
    `user_type`, `role`, `reliability_score`, `is_blocked`, 
    `is_verified`, `created_at`, `updated_at`
) VALUES (
    'Test Buyer',
    'buyer@flex.com',
    '9555555555',
    '$2y$10$92IXUNpkjO0rOQ5byMi.Ye4oKoEa3Ro9llC/.og/at2.uheWG/igi',
    '123 Buyer Street, City Center',
    '110005',
    'buyer',
    'buyer',
    50,
    0,
    1,
    NOW(),
    NOW()
);

-- Verify created users
SELECT id, name, email, user_type, role, reliability_score, is_verified 
FROM users 
WHERE email IN (
    'superadmin@flex.com',
    'admin@flex.com',
    'seller@flex.com',
    'delivery@flex.com',
    'buyer@flex.com'
)
ORDER BY 
    FIELD(role, 'super_admin', 'admin', 'seller', 'delivery', 'buyer');

-- Display login credentials
SELECT 
    '=== DUMMY USER CREDENTIALS ===' AS 'INFO',
    '' AS 'Email',
    '' AS 'Password',
    '' AS 'Role'
UNION ALL
SELECT '', 'superadmin@flex.com', 'Super@123', 'Super Admin'
UNION ALL
SELECT '', 'admin@flex.com', 'Admin@123', 'Admin'
UNION ALL
SELECT '', 'seller@flex.com', 'Seller@123', 'Seller'
UNION ALL
SELECT '', 'delivery@flex.com', 'Delivery@123', 'Delivery'
UNION ALL
SELECT '', 'buyer@flex.com', 'Buyer@123', 'Buyer';

