<?php
// Fix SuperAdmin controller access checks

$file = 'd:/xampp/htdocs/flex/app/Controllers/SuperAdmin.php';
$content = file_get_contents($file);

// Pattern to match: if (!session()->get('logged_in') || session()->get('user_type') !== 'super_admin') {
//                     return redirect()->to('/login');
// OR:                return $this->response->setJSON(['success' => false, 'message' => 'Unauthorized']);

$pattern1 = "/if \(\!session\(\)->get\('logged_in'\) \|\| session\(\)->get\('user_type'\) !== 'super_admin'\) \{\s+return redirect\(\)->to\('\/login'\);\s+\}/";
$pattern2 = "/if \(\!session\(\)->get\('logged_in'\) \|\| session\(\)->get\('user_type'\) !== 'super_admin'\) \{\s+return \\\$this->response->setJSON\(\['success' => false, 'message' => 'Unauthorized'\]\);\s+\}/";

$replacement1 = 'if ($check = $this->checkSuperAdminAccess()) return $check;';
$replacement2 = 'if ($check = $this->checkSuperAdminAccess()) return $check;';

$content = preg_replace($pattern1, $replacement1, $content);
$content = preg_replace($pattern2, $replacement2, $content);

file_put_contents($file, $content);

echo "Fixed SuperAdmin.php - replaced inline checks with checkSuperAdminAccess() method\n";
?>
