-- Flex Market - Quick Setup SQL
-- Run this after registration to test admin features

-- 1. Make your user an admin (replace YOUR_EMAIL with your registered email)
UPDATE users 
SET role = 'admin', 
    reliability_score = 50 
WHERE email = 'iamrajan0000@gmail.com';

-- 2. Create a test seller with high reliability (optional)
-- INSERT INTO users (name, email, mobile, password, address, pin_code, user_type, role, reliability_score, is_verified, created_at, updated_at) 
-- VALUES ('Test Seller', 'seller@test.com', '9876543210', '$2y$10$YourHashedPasswordHere', 'Test Address', '110001', 'seller', 'seller', 30, 1, NOW(), NOW());

-- 3. Insert some allowed locations (optional)
INSERT INTO allowed_locations (pin_code, city, state, is_active, created_at) VALUES
('110001', 'New Delhi', 'Delhi', 1, NOW()),
('400001', 'Mumbai', 'Maharashtra', 1, NOW()),
('560001', 'Bangalore', 'Karnataka', 1, NOW()),
('700001', 'Kolkata', 'West Bengal', 1, NOW()),
('600001', 'Chennai', 'Tamil Nadu', 1, NOW());

-- 4. Insert default admin settings
INSERT INTO admin_settings (setting_key, setting_value, description, updated_at) VALUES
('min_reliability_for_brand', '25', 'Minimum reliability score required to create a brand', NOW()),
('max_product_images', '7', 'Maximum number of images per product', NOW()),
('review_window_days', '20', 'Days allowed to submit review after delivery', NOW()),
('platform_commission', '5', 'Platform commission percentage', NOW());

-- Verify admin user
SELECT id, name, email, user_type, role, reliability_score FROM users WHERE email = 'iamrajan0000@gmail.com';
