# Flex Market - Implementation Roadmap

## Database Schema Overview

Based on the requirements, here are the tables we need:

### Core Tables
1. **users** - Already exists (name, email, mobile, password, address, pin_code, user_type, reliability_score)
2. **products** - Product listings (sell/rent)
3. **brands** - Seller brands (when reliability > 25)
4. **offers** - Buyer offers on products
5. **orders** - Confirmed transactions
6. **transactions** - Payment/credit history
7. **reviews** - Buyer/seller ratings
8. **notifications** - System notifications
9. **delivery_persons** - Delivery agents
10. **admin_settings** - System configurations

### Supporting Tables
11. **product_images** - Product photos (max 7)
12. **allowed_locations** - Pin codes/cities/states
13. **order_status_history** - Track order stages
14. **brands_products** - Link brands to products

---

## Phase 1 Features Priority

### Seller Features (Phase 1)
- ✅ S1: Upload product (sell/rent option)
- S19: Product details (size, color, price, photos, bill)
- S17: Rental details (cost, deposit, fitting, photos)
- S36: Product visible with seller name
- S10: View seller dashboard
- S25: View offers with buyer stars
- S24: Accept/Reject offers
- S33: Give stars to buyer (within 20 days)

### Admin Features (Phase 1)
- SA6: View pending publish requests
- SA7: Approve/reject products
- SA10: Block users (seller/buyer/delivery)
- SA5: View live products
- SA9: View products under review

---

## Implementation Steps

### Step 1: Database Migrations ✓ Next
Create migrations for:
- products
- brands
- offers
- orders
- transactions
- reviews
- notifications
- delivery_persons
- admin_settings
- product_images
- allowed_locations

### Step 2: Models
Create models for each table with relationships

### Step 3: Controllers
- SellerController - Product CRUD, offers, orders
- AdminController - Approval, blocking, settings
- SuperAdminController - Advanced admin features

### Step 4: Views
- Seller Dashboard
- Product Upload Form
- Offers Management
- Admin Panel
- Product Approval Queue

### Step 5: Features (Incremental)
Implement one feature at a time, test, then move to next

---

## Questions for You:

1. **Start with which phase?**
   - Phase 1 Seller features (product upload, offers)?
   - Phase 1 Admin features (approve products, block users)?
   - Database schema first?

2. **User roles:**
   - Do we need separate `admin` and `super_admin` user types in DB?
   - Or just add `role` column (buyer, seller, admin, super_admin, delivery)?

3. **Product approval flow:**
   - Seller uploads → Admin approves → Goes live?
   - Or auto-publish for verified sellers?

**Recommendation:** Let's start with:
1. Create all database migrations
2. Build Seller product upload (S1, S17, S19)
3. Build Admin approval panel (SA6, SA7)
4. Then add offers system

Should I proceed with creating database migrations first?
