# Flex Market - OTP Authentication Setup Guide

## Phase 1 Complete ✅

### What's Been Implemented:

1. **Database Migration** - User table with all required fields
2. **User Model** - Complete with OTP generation and verification
3. **Auth Controller** - Registration, Login, OTP verification
4. **Views Created**:
   - Registration page (with Seller/Buyer selection)
   - Login page (OTP request)
   - OTP verification page
   - Dashboard page

---

## Setup Steps to Run the Application:

### Step 1: Run Database Migration
```bash
php spark migrate
```

### Step 2: Configure Email Settings

Open `app/Config/Email.php` and update:

```php
public string $SMTPHost = 'smtp.gmail.com';
public string $SMTPUser = 'your-email@gmail.com';
public string $SMTPPass = 'your-app-password';
```

**For Gmail:**
1. Go to Google Account Settings
2. Security > 2-Step Verification (enable it)
3. App Passwords > Generate new password
4. Use that password in `SMTPPass`

**Alternative (for local testing):**
Use Mailtrap.io or similar service:
```php
public string $SMTPHost = 'smtp.mailtrap.io';
public string $SMTPUser = 'your-mailtrap-username';
public string $SMTPPass = 'your-mailtrap-password';
public int $SMTPPort = 2525;
```

### Step 3: Start the Development Server
```bash
php spark serve
```

### Step 4: Access the Application
- Homepage: http://localhost:8080/
- Registration: http://localhost:8080/register
- Login: http://localhost:8080/auth/login

---

## Features Implemented:

### ✅ User Registration
- Full name (required)
- Email (required, unique)
- Mobile number (required)
- Address (required)
- PIN code (required)
- User type selection (Seller/Buyer)
- OTP sent to email after registration

### ✅ OTP-Based Login
- Email-based OTP authentication
- 6-digit OTP with 10-minute expiry
- Beautiful OTP input interface
- Auto-focus and paste support

### ✅ User Dashboard
- Welcome message with user name
- User type display (Seller/Buyer)
- Placeholder for future features (Products, Favorites, Messages)
- Profile information display
- Logout functionality

### ✅ Security Features
- CSRF protection enabled
- Email validation
- OTP expiration (10 minutes)
- Session-based authentication
- Unique email constraint

---

## Database Structure:

**Users Table:**
- id
- name
- email (unique)
- mobile
- address
- pin_code
- user_type (seller/buyer)
- otp
- otp_expires_at
- is_verified
- created_at
- updated_at

---

## Routes Available:

| Route | Method | Description |
|-------|--------|-------------|
| `/` | GET | Homepage (current login.php view) |
| `/register` | GET | Registration page |
| `/auth/process-register` | POST | Process registration & send OTP |
| `/auth/login` | GET | Login page (request OTP) |
| `/auth/send-login-otp` | POST | Send OTP to email |
| `/verify-otp` | GET | OTP verification page |
| `/auth/process-verify-otp` | POST | Verify OTP & login |
| `/dashboard` | GET | User dashboard (protected) |
| `/auth/logout` | GET | Logout |

---

## Testing the Flow:

### Registration Flow:
1. Go to `/register`
2. Select Seller or Buyer
3. Fill in all details
4. Click "Register & Send OTP"
5. Check email for OTP
6. Enter 6-digit OTP
7. Redirected to Dashboard

### Login Flow:
1. Go to `/auth/login`
2. Enter registered email
3. Click "Send OTP"
4. Check email for OTP
5. Enter 6-digit OTP
6. Redirected to Dashboard

---

## Next Steps (Future Phases):

- [ ] Product listing functionality
- [ ] Product categories implementation
- [ ] Search functionality
- [ ] Seller dashboard with product management
- [ ] Buyer dashboard with favorites
- [ ] Messaging system
- [ ] Image upload for products
- [ ] Payment integration
- [ ] Order management

---

## Troubleshooting:

**Email not sending?**
- Check SMTP credentials in `app/Config/Email.php`
- Use Mailtrap.io for local testing
- Enable "Less secure app access" for Gmail (or use App Password)

**Database errors?**
- Run `php spark migrate` to create tables
- Check database connection in `app/Config/Database.php`

**Session issues?**
- Clear session: delete files in `writable/session/`
- Check write permissions on `writable/` folder

---

## Files Created/Modified:

### New Files:
- `app/Database/Migrations/2026-01-04-120000_CreateUsersTable.php`
- `app/Models/UserModel.php`
- `app/Controllers/Auth.php`
- `app/Views/register.php`
- `app/Views/login_otp.php`
- `app/Views/verify_otp.php`
- `app/Views/dashboard.php`

### Modified Files:
- `app/Controllers/Home.php` - Changed to return login view
- `app/Config/Routes.php` - Added auth routes
- `app/Config/Email.php` - Configured SMTP settings

---

**Ready to proceed with next phase!** 🚀
