<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Admin Dashboard - Flex Market</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.css">
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <style>
        * {
            font-family: 'Poppins', sans-serif;
        }
        .sidebar {
            min-height: 100vh;
            background: linear-gradient(135deg, #2c3e50 0%, #3498db 100%);
        }
        .sidebar .nav-link {
            color: rgba(255,255,255,0.8);
            padding: 12px 20px;
            border-radius: 8px;
            margin: 5px 0;
        }
        .sidebar .nav-link:hover, .sidebar .nav-link.active {
            background: rgba(255,255,255,0.2);
            color: #fff;
        }
        .stat-card {
            border-radius: 15px;
            padding: 25px;
            border: none;
            box-shadow: 0 4px 6px rgba(0,0,0,0.1);
        }
    </style>
</head>
<body class="bg-light">
    <div class="container-fluid">
        <div class="row">
            <!-- Sidebar -->
            <div class="col-md-3 col-lg-2 sidebar text-white p-4">
                <h4 class="mb-4"><i class="bi bi-shield-check"></i> Admin Panel</h4>
                <div class="mb-4">
                    <h6><?= esc($user['name']) ?></h6>
                    <small>Administrator</small>
                </div>
                <ul class="nav flex-column">
                    <li class="nav-item">
                        <a class="nav-link active" href="<?= base_url('admin/dashboard') ?>">
                            <i class="bi bi-speedometer2"></i> Dashboard
                        </a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="<?= base_url('admin/pending-products') ?>">
                            <i class="bi bi-clock-history"></i> Pending Approvals
                            <?php if ($pending_products > 0): ?>
                                <span class="badge bg-danger"><?= $pending_products ?></span>
                            <?php endif; ?>
                        </a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="<?= base_url('admin/products') ?>">
                            <i class="bi bi-box-seam"></i> All Products
                        </a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="<?= base_url('admin/users') ?>">
                            <i class="bi bi-people"></i> Users
                        </a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="<?= base_url('admin/orders') ?>">
                            <i class="bi bi-cart-check"></i> Orders
                        </a>
                    </li>
                    <li class="nav-item mt-3">
                        <a class="nav-link" href="<?= base_url('auth/logout') ?>">
                            <i class="bi bi-box-arrow-right"></i> Logout
                        </a>
                    </li>
                </ul>
            </div>

            <!-- Main Content -->
            <div class="col-md-9 col-lg-10 p-4">
                <h2 class="mb-4">Admin Dashboard</h2>

                <!-- Stats Cards -->
                <div class="row g-4 mb-4">
                    <div class="col-md-3">
                        <div class="card stat-card bg-danger text-white">
                            <h3><?= $pending_products ?></h3>
                            <p class="mb-0"><i class="bi bi-clock-history"></i> Pending Approvals</p>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="card stat-card bg-primary text-white">
                            <h3><?= $total_products ?></h3>
                            <p class="mb-0"><i class="bi bi-box-seam"></i> Total Products</p>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="card stat-card bg-success text-white">
                            <h3><?= $total_users ?></h3>
                            <p class="mb-0"><i class="bi bi-people"></i> Total Users</p>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="card stat-card bg-info text-white">
                            <h3><?= $total_orders ?></h3>
                            <p class="mb-0"><i class="bi bi-cart-check"></i> Total Orders</p>
                        </div>
                    </div>
                </div>

                <!-- Quick Actions -->
                <div class="row g-4">
                    <div class="col-md-6">
                        <div class="card">
                            <div class="card-body text-center p-5">
                                <i class="bi bi-clock-history text-warning" style="font-size: 3rem;"></i>
                                <h4 class="mt-3">Pending Approvals</h4>
                                <p class="text-muted">Review and approve product submissions</p>
                                <a href="<?= base_url('admin/pending-products') ?>" class="btn btn-warning">
                                    View Pending Products (<?= $pending_products ?>)
                                </a>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="card">
                            <div class="card-body text-center p-5">
                                <i class="bi bi-people text-primary" style="font-size: 3rem;"></i>
                                <h4 class="mt-3">User Management</h4>
                                <p class="text-muted">Manage sellers, buyers, and delivery persons</p>
                                <a href="<?= base_url('admin/users') ?>" class="btn btn-primary">
                                    Manage Users
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
