<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>My Transactions - Flex Market</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.min.css">
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <style>
        body {
            font-family: 'Poppins', sans-serif;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            min-height: 100vh;
            padding: 20px 0;
        }
        .container {
            max-width: 1200px;
        }
        .page-header {
            background: white;
            padding: 30px;
            border-radius: 15px;
            margin-bottom: 30px;
            box-shadow: 0 2px 15px rgba(0,0,0,0.1);
        }
        .page-header h1 {
            color: #764ba2;
            font-weight: 600;
            margin: 0;
        }
        .filter-tabs {
            background: white;
            padding: 20px;
            border-radius: 15px;
            margin-bottom: 20px;
            box-shadow: 0 2px 15px rgba(0,0,0,0.1);
        }
        .nav-pills .nav-link {
            border-radius: 10px;
            padding: 10px 20px;
            font-weight: 500;
            color: #764ba2;
        }
        .nav-pills .nav-link.active {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
        }
        .transaction-card {
            background: white;
            border-radius: 15px;
            padding: 20px;
            margin-bottom: 20px;
            box-shadow: 0 2px 15px rgba(0,0,0,0.1);
            transition: all 0.3s;
        }
        .transaction-card:hover {
            box-shadow: 0 5px 25px rgba(0,0,0,0.15);
            transform: translateY(-2px);
        }
        .product-image {
            width: 120px;
            height: 120px;
            object-fit: cover;
            border-radius: 10px;
        }
        .status-badge {
            padding: 8px 16px;
            border-radius: 20px;
            font-size: 0.85rem;
            font-weight: 500;
        }
        .status-pending { background: #fff3cd; color: #856404; }
        .status-dispatched { background: #cfe2ff; color: #084298; }
        .status-delivered { background: #d1e7dd; color: #0f5132; }
        .status-completed { background: #d1e7dd; color: #0f5132; }
        .status-cancelled { background: #f8d7da; color: #842029; }
        .order-details {
            display: flex;
            gap: 15px;
            align-items: start;
        }
        .order-info {
            flex: 1;
        }
        .order-info h5 {
            color: #2c3e50;
            font-weight: 600;
            margin-bottom: 10px;
        }
        .order-meta {
            color: #6c757d;
            font-size: 0.9rem;
            margin-bottom: 5px;
        }
        .price-info {
            text-align: right;
        }
        .price-amount {
            font-size: 1.5rem;
            color: #764ba2;
            font-weight: 600;
        }
        .btn-view {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            border: none;
            padding: 8px 20px;
            border-radius: 10px;
            font-weight: 500;
            margin-top: 10px;
        }
        .btn-view:hover {
            opacity: 0.9;
            color: white;
        }
        .btn-rate {
            background: linear-gradient(135deg, #f093fb 0%, #f5576c 100%);
            color: white;
            border: none;
            padding: 8px 20px;
            border-radius: 10px;
            font-weight: 500;
            margin-top: 10px;
        }
        .empty-state {
            background: white;
            padding: 60px 20px;
            border-radius: 15px;
            text-align: center;
        }
        .empty-state i {
            font-size: 4rem;
            color: #ddd;
            margin-bottom: 20px;
        }
        .timeline {
            margin-top: 15px;
            padding-top: 15px;
            border-top: 1px solid #e9ecef;
        }
        .timeline-item {
            font-size: 0.85rem;
            color: #6c757d;
            margin-bottom: 8px;
        }
        .timeline-item i {
            color: #764ba2;
            margin-right: 8px;
        }
    </style>
</head>
<body>
    <div class="container">
        <!-- Header -->
        <div class="page-header">
            <div class="d-flex justify-content-between align-items-center">
                <div>
                    <h1><i class="bi bi-receipt"></i> My Transactions</h1>
                    <p class="text-muted mb-0">Track your orders and purchase history</p>
                </div>
                <a href="<?= base_url('buyer') ?>" class="btn btn-view">
                    <i class="bi bi-arrow-left"></i> Back to Browse
                </a>
            </div>
        </div>

        <!-- Filter Tabs -->
        <div class="filter-tabs">
            <ul class="nav nav-pills" id="statusTabs" role="tablist">
                <li class="nav-item" role="presentation">
                    <button class="nav-link active" id="all-tab" data-bs-toggle="pill" data-bs-target="#all" type="button">
                        All Orders (<?= count($transactions ?? []) ?>)
                    </button>
                </li>
                <li class="nav-item" role="presentation">
                    <button class="nav-link" id="pending-tab" data-bs-toggle="pill" data-bs-target="#pending" type="button">
                        Pending
                    </button>
                </li>
                <li class="nav-item" role="presentation">
                    <button class="nav-link" id="dispatched-tab" data-bs-toggle="pill" data-bs-target="#dispatched" type="button">
                        Dispatched
                    </button>
                </li>
                <li class="nav-item" role="presentation">
                    <button class="nav-link" id="completed-tab" data-bs-toggle="pill" data-bs-target="#completed" type="button">
                        Completed
                    </button>
                </li>
            </ul>
        </div>

        <!-- Transactions List -->
        <div class="tab-content" id="statusTabsContent">
            <div class="tab-pane fade show active" id="all">
                <?php if (empty($transactions)): ?>
                    <div class="empty-state">
                        <i class="bi bi-inbox"></i>
                        <h4>No Transactions Yet</h4>
                        <p class="text-muted">Start shopping to see your order history here</p>
                        <a href="<?= base_url('buyer') ?>" class="btn btn-view">Browse Products</a>
                    </div>
                <?php else: ?>
                    <?php foreach ($transactions as $transaction): ?>
                        <div class="transaction-card">
                            <div class="order-details">
                                <img src="<?= esc($transaction['primary_image'] ?? '/images/no-image.jpg') ?>" 
                                     alt="Product" 
                                     class="product-image">
                                
                                <div class="order-info">
                                    <h5><?= esc($transaction['title']) ?></h5>
                                    
                                    <div class="order-meta">
                                        <i class="bi bi-tag"></i> 
                                        Order #<?= esc($transaction['order_number'] ?? $transaction['id']) ?>
                                    </div>
                                    
                                    <div class="order-meta">
                                        <i class="bi bi-shop"></i> 
                                        Seller: <?= esc($transaction['seller_name']) ?>
                                    </div>
                                    
                                    <div class="order-meta">
                                        <i class="bi bi-calendar"></i> 
                                        <?= date('d M Y, h:i A', strtotime($transaction['created_at'])) ?>
                                    </div>

                                    <?php if ($transaction['listing_type'] === 'rent'): ?>
                                        <div class="order-meta">
                                            <i class="bi bi-calendar-range"></i> 
                                            Rental: <?= date('d M', strtotime($transaction['rental_start_date'])) ?> - 
                                            <?= date('d M Y', strtotime($transaction['rental_end_date'])) ?>
                                            <span class="badge bg-info ms-2">
                                                <?php 
                                                $start = new DateTime($transaction['rental_start_date']);
                                                $end = new DateTime($transaction['rental_end_date']);
                                                $days = $start->diff($end)->days + 1;
                                                echo $days . ' day' . ($days > 1 ? 's' : '');
                                                ?>
                                            </span>
                                        </div>
                                    <?php endif; ?>

                                    <div class="mt-2">
                                        <span class="status-badge status-<?= esc($transaction['status'] ?? 'pending') ?>">
                                            <?= ucfirst(esc($transaction['status'] ?? 'Pending')) ?>
                                        </span>
                                    </div>

                                    <!-- Timeline (Phase 2) -->
                                    <?php if (!empty($transaction['timeline'])): ?>
                                        <div class="timeline">
                                            <?php foreach ($transaction['timeline'] as $event): ?>
                                                <div class="timeline-item">
                                                    <i class="bi bi-check-circle-fill"></i>
                                                    <?= esc($event['status']) ?> - 
                                                    <?= date('d M Y, h:i A', strtotime($event['created_at'])) ?>
                                                </div>
                                            <?php endforeach; ?>
                                        </div>
                                    <?php endif; ?>
                                </div>

                                <div class="price-info">
                                    <div class="price-amount">₹<?= number_format($transaction['final_price'] ?? 0, 2) ?></div>
                                    <div class="text-muted" style="font-size: 0.85rem;">
                                        <?= $transaction['listing_type'] === 'rent' ? 'Rental + Deposit' : 'Sale Price' ?>
                                    </div>
                                    
                                    <a href="<?= base_url('buyer/order/' . $transaction['id']) ?>" class="btn btn-view">
                                        <i class="bi bi-eye"></i> View Details
                                    </a>

                                    <?php if ($transaction['status'] === 'completed' && empty($transaction['rated'])): ?>
                                        <button class="btn btn-rate" onclick="rateOrder(<?= $transaction['id'] ?>)">
                                            <i class="bi bi-star"></i> Rate Seller
                                        </button>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                    <?php endforeach; ?>
                <?php endif; ?>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
    <script>
        function rateOrder(orderId) {
            // TODO: Open rating modal (S33, B24)
            alert('Rating feature coming soon!');
        }

        // Filter transactions by status
        document.querySelectorAll('[data-bs-toggle="pill"]').forEach(tab => {
            tab.addEventListener('shown.bs.tab', function(e) {
                const target = e.target.getAttribute('data-bs-target');
                // TODO: Filter logic (currently showing all in one tab)
            });
        });
    </script>
</body>
</html>
