<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Dashboard - Flex Market</title>
    
    <!-- Bootstrap 5 -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <!-- Bootstrap Icons -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.css" rel="stylesheet">
    <!-- Poppins Font -->
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;500;600;700&display=swap" rel="stylesheet">
    
    <style>
        body {
            font-family: 'Poppins', sans-serif;
            background-color: #f8f9fa;
        }
        .navbar {
            background-color: #fff;
            box-shadow: 0 2px 10px rgba(0,0,0,0.05);
            padding: 1rem 0;
        }
        .navbar-brand {
            font-weight: 700;
            font-size: 1.5rem;
        }
        .dashboard-container {
            padding: 40px 0;
        }
        .welcome-card {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: #fff;
            border-radius: 20px;
            padding: 40px;
            margin-bottom: 30px;
        }
        .welcome-card h2 {
            font-weight: 700;
            margin-bottom: 10px;
        }
        .stats-card {
            background: #fff;
            border-radius: 15px;
            padding: 30px;
            box-shadow: 0 4px 15px rgba(0,0,0,0.05);
            margin-bottom: 20px;
            text-align: center;
        }
        .stats-card i {
            font-size: 3rem;
            color: #ffc107;
            margin-bottom: 15px;
        }
        .stats-card h4 {
            font-weight: 600;
            margin-bottom: 5px;
        }
        .user-info {
            background: #fff;
            border-radius: 15px;
            padding: 30px;
            box-shadow: 0 4px 15px rgba(0,0,0,0.05);
        }
        .btn-logout {
            background-color: #dc3545;
            color: #fff;
            border: none;
            padding: 10px 25px;
            border-radius: 8px;
            font-weight: 500;
        }
        .btn-logout:hover {
            background-color: #c82333;
            color: #fff;
        }
    </style>
</head>
<body>
    <!-- Navbar -->
    <nav class="navbar navbar-expand-lg">
        <div class="container">
            <a class="navbar-brand" href="<?= base_url('/') ?>">Flex Market</a>
            <div class="ms-auto">
                <a href="<?= base_url('auth/logout') ?>" class="btn btn-logout">
                    <i class="bi bi-box-arrow-right"></i> Logout
                </a>
            </div>
        </div>
    </nav>

    <!-- Dashboard Content -->
    <div class="container dashboard-container">
        <?php if (session()->getFlashdata('success')): ?>
            <div class="alert alert-success alert-dismissible fade show" role="alert">
                <?= session()->getFlashdata('success') ?>
                <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
            </div>
        <?php endif; ?>

        <div class="welcome-card">
            <h2>Welcome back, <?= session()->get('user_name') ?>! 👋</h2>
            <p class="mb-0">You're logged in as a <strong><?= ucfirst(session()->get('user_type')) ?></strong></p>
        </div>

        <div class="row">
            <div class="col-md-4">
                <div class="stats-card">
                    <i class="bi bi-box-seam"></i>
                    <h4>My Products</h4>
                    <p class="text-muted mb-0">0 Products</p>
                </div>
            </div>
            <div class="col-md-4">
                <div class="stats-card">
                    <i class="bi bi-heart"></i>
                    <h4>Favorites</h4>
                    <p class="text-muted mb-0">0 Items</p>
                </div>
            </div>
            <div class="col-md-4">
                <div class="stats-card">
                    <i class="bi bi-chat-dots"></i>
                    <h4>Messages</h4>
                    <p class="text-muted mb-0">0 Messages</p>
                </div>
            </div>
        </div>

        <div class="user-info">
            <h4 class="mb-4">Profile Information</h4>
            <div class="row">
                <div class="col-md-6 mb-3">
                    <strong>Email:</strong><br>
                    <?= session()->get('user_email') ?>
                </div>
                <div class="col-md-6 mb-3">
                    <strong>Account Type:</strong><br>
                    <?= ucfirst(session()->get('user_type')) ?>
                </div>
            </div>
            <div class="mt-4">
                <a href="<?= base_url('/') ?>" class="btn btn-outline-primary">
                    <i class="bi bi-house"></i> Back to Home
                </a>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
