<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Earnings - Flex Market</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.css">
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <style>
        * { font-family: 'Poppins', sans-serif; }
        body { background: #f5f5f5; }
        .sidebar {
            min-height: 100vh;
            background: linear-gradient(180deg, #00897b 0%, #00695c 100%);
        }
        .sidebar .nav-link {
            color: rgba(255,255,255,0.85);
            padding: 14px 20px;
            border-radius: 10px;
            margin: 6px 0;
        }
        .sidebar .nav-link:hover, .sidebar .nav-link.active {
            background: rgba(255,255,255,0.15);
            color: #fff;
        }
        .sidebar .nav-link i { margin-right: 10px; }
        .earning-card {
            background: linear-gradient(135deg, #00897b 0%, #00695c 100%);
            border-radius: 15px;
            padding: 30px;
            color: white;
            box-shadow: 0 5px 20px rgba(0,137,123,0.3);
        }
        .stat-box {
            background: white;
            border-radius: 12px;
            padding: 20px;
            box-shadow: 0 2px 10px rgba(0,0,0,0.06);
        }
    </style>
</head>
<body>
    <div class="container-fluid">
        <div class="row">
            <!-- Sidebar -->
            <div class="col-md-3 col-lg-2 px-0 sidebar">
                <div class="p-3">
                    <h4 class="text-white mb-4"><i class="bi bi-truck"></i> Delivery Panel</h4>
                    <nav class="nav flex-column">
                        <a href="<?= base_url('delivery/dashboard') ?>" class="nav-link">
                            <i class="bi bi-speedometer2"></i> Dashboard
                        </a>
                        <a href="<?= base_url('delivery/history') ?>" class="nav-link">
                            <i class="bi bi-clock-history"></i> History
                        </a>
                        <a href="<?= base_url('delivery/earnings') ?>" class="nav-link active">
                            <i class="bi bi-currency-rupee"></i> Earnings
                        </a>
                        <a href="<?= base_url('auth/logout') ?>" class="nav-link mt-4">
                            <i class="bi bi-box-arrow-right"></i> Logout
                        </a>
                    </nav>
                </div>
            </div>

            <!-- Main Content -->
            <div class="col-md-9 col-lg-10 p-4">
                <h2 class="mb-4"><i class="bi bi-currency-rupee"></i> Earnings</h2>

                <div class="row g-4 mb-4">
                    <div class="col-md-8">
                        <div class="earning-card">
                            <h5 class="mb-2">Total Earnings</h5>
                            <h1 class="mb-0">₹<?= number_format($totalEarnings) ?></h1>
                            <p class="mb-0 mt-2 opacity-75">From <?= $totalDeliveries ?> deliveries</p>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="stat-box mb-3">
                            <p class="text-muted mb-1">Today's Earnings</p>
                            <h3 class="mb-0 text-success">₹<?= number_format($todayEarnings) ?></h3>
                        </div>
                        <div class="stat-box">
                            <p class="text-muted mb-1">This Week</p>
                            <h3 class="mb-0 text-primary">₹<?= number_format($weekEarnings) ?></h3>
                        </div>
                    </div>
                </div>

                <div class="stat-box">
                    <h5 class="mb-3">Earnings Breakdown</h5>
                    <table class="table table-borderless mb-0">
                        <thead>
                            <tr>
                                <th>Period</th>
                                <th>Deliveries</th>
                                <th>Amount</th>
                            </tr>
                        </thead>
                        <tbody>
                            <tr>
                                <td>Today</td>
                                <td><?= $todayDeliveries ?></td>
                                <td class="text-success fw-bold">₹<?= number_format($todayEarnings) ?></td>
                            </tr>
                            <tr>
                                <td>This Week</td>
                                <td><?= $weekDeliveries ?></td>
                                <td class="text-primary fw-bold">₹<?= number_format($weekEarnings) ?></td>
                            </tr>
                            <tr>
                                <td>This Month</td>
                                <td><?= $monthDeliveries ?></td>
                                <td class="text-info fw-bold">₹<?= number_format($monthEarnings) ?></td>
                            </tr>
                            <tr class="table-active">
                                <td><strong>All Time</strong></td>
                                <td><strong><?= $totalDeliveries ?></strong></td>
                                <td><strong>₹<?= number_format($totalEarnings) ?></strong></td>
                            </tr>
                        </tbody>
                    </table>
                </div>

                <div class="stat-box mt-4">
                    <h5 class="mb-3">Payment Details</h5>
                    <div class="alert alert-info">
                        <i class="bi bi-info-circle"></i> Earnings are calculated at ₹50 per delivery. 
                        Payments are processed weekly and will be transferred to your registered bank account.
                    </div>
                    <p class="mb-1"><strong>Next Payout Date:</strong> <?= date('d M Y', strtotime('next Friday')) ?></p>
                    <p class="mb-0"><strong>Payout Amount:</strong> ₹<?= number_format($weekEarnings) ?></p>
                </div>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
