<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Delivery History - Flex Market</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.css">
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <style>
        * { font-family: 'Poppins', sans-serif; }
        body { background: #f5f5f5; }
        .sidebar {
            min-height: 100vh;
            background: linear-gradient(180deg, #00897b 0%, #00695c 100%);
        }
        .sidebar .nav-link {
            color: rgba(255,255,255,0.85);
            padding: 14px 20px;
            border-radius: 10px;
            margin: 6px 0;
        }
        .sidebar .nav-link:hover, .sidebar .nav-link.active {
            background: rgba(255,255,255,0.15);
            color: #fff;
        }
        .sidebar .nav-link i { margin-right: 10px; }
        .history-table {
            background: white;
            border-radius: 12px;
            overflow: hidden;
            box-shadow: 0 2px 10px rgba(0,0,0,0.06);
        }
    </style>
</head>
<body>
    <div class="container-fluid">
        <div class="row">
            <!-- Sidebar -->
            <div class="col-md-3 col-lg-2 px-0 sidebar">
                <div class="p-3">
                    <h4 class="text-white mb-4"><i class="bi bi-truck"></i> Delivery Panel</h4>
                    <nav class="nav flex-column">
                        <a href="<?= base_url('delivery/dashboard') ?>" class="nav-link">
                            <i class="bi bi-speedometer2"></i> Dashboard
                        </a>
                        <a href="<?= base_url('delivery/history') ?>" class="nav-link active">
                            <i class="bi bi-clock-history"></i> History
                        </a>
                        <a href="<?= base_url('delivery/earnings') ?>" class="nav-link">
                            <i class="bi bi-currency-rupee"></i> Earnings
                        </a>
                        <a href="<?= base_url('auth/logout') ?>" class="nav-link mt-4">
                            <i class="bi bi-box-arrow-right"></i> Logout
                        </a>
                    </nav>
                </div>
            </div>

            <!-- Main Content -->
            <div class="col-md-9 col-lg-10 p-4">
                <h2 class="mb-4"><i class="bi bi-clock-history"></i> Delivery History</h2>

                <div class="history-table">
                    <div class="p-3">
                        <table class="table table-hover mb-0">
                            <thead>
                                <tr>
                                    <th>Order ID</th>
                                    <th>Product</th>
                                    <th>Pickup Date</th>
                                    <th>Delivery Date</th>
                                    <th>Amount</th>
                                    <th>Earning</th>
                                    <th>Status</th>
                                    <th>Action</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php if (!empty($deliveries)): ?>
                                    <?php foreach ($deliveries as $delivery): ?>
                                        <tr>
                                            <td>#<?= esc($delivery['id']) ?></td>
                                            <td><?= esc($delivery['product_name']) ?></td>
                                            <td><?= $delivery['pickup_date'] ? date('d M Y', strtotime($delivery['pickup_date'])) : 'N/A' ?></td>
                                            <td><?= $delivery['delivery_date'] ? date('d M Y', strtotime($delivery['delivery_date'])) : 'Pending' ?></td>
                                            <td>₹<?= number_format($delivery['final_price']) ?></td>
                                            <td class="text-success fw-bold">₹50</td>
                                            <td>
                                                <span class="badge bg-<?= $delivery['status'] === 'delivered' ? 'success' : ($delivery['status'] === 'in_transit' ? 'primary' : 'warning') ?>">
                                                    <?= ucwords(str_replace('_', ' ', $delivery['status'])) ?>
                                                </span>
                                            </td>
                                            <td>
                                                <a href="<?= base_url('delivery/order/' . $delivery['id']) ?>" class="btn btn-sm btn-outline-primary">
                                                    <i class="bi bi-eye"></i> View
                                                </a>
                                            </td>
                                        </tr>
                                    <?php endforeach; ?>
                                <?php else: ?>
                                    <tr>
                                        <td colspan="8" class="text-center py-4 text-muted">
                                            <i class="bi bi-inbox fs-1 d-block mb-2"></i>
                                            No delivery history found
                                        </td>
                                    </tr>
                                <?php endif; ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
