<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Order Details - Flex Market</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.css">
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <style>
        * { font-family: 'Poppins', sans-serif; }
        body { background: #f5f5f5; }
        .sidebar {
            min-height: 100vh;
            background: linear-gradient(180deg, #00897b 0%, #00695c 100%);
        }
        .sidebar .nav-link {
            color: rgba(255,255,255,0.85);
            padding: 14px 20px;
            border-radius: 10px;
            margin: 6px 0;
        }
        .sidebar .nav-link:hover, .sidebar .nav-link.active {
            background: rgba(255,255,255,0.15);
            color: #fff;
        }
        .sidebar .nav-link i { margin-right: 10px; }
        .info-box {
            background: white;
            border-radius: 12px;
            padding: 20px;
            box-shadow: 0 2px 10px rgba(0,0,0,0.06);
        }
        .timeline {
            position: relative;
            padding-left: 30px;
        }
        .timeline::before {
            content: '';
            position: absolute;
            left: 10px;
            top: 0;
            bottom: 0;
            width: 2px;
            background: #e0e0e0;
        }
        .timeline-item {
            position: relative;
            margin-bottom: 25px;
        }
        .timeline-item::before {
            content: '';
            position: absolute;
            left: -24px;
            top: 5px;
            width: 14px;
            height: 14px;
            border-radius: 50%;
            background: #4caf50;
            border: 3px solid white;
            box-shadow: 0 0 0 2px #4caf50;
        }
        .timeline-item.pending::before { background: #ff9800; box-shadow: 0 0 0 2px #ff9800; }
    </style>
</head>
<body>
    <div class="container-fluid">
        <div class="row">
            <!-- Sidebar -->
            <div class="col-md-3 col-lg-2 px-0 sidebar">
                <div class="p-3">
                    <h4 class="text-white mb-4"><i class="bi bi-truck"></i> Delivery Panel</h4>
                    <nav class="nav flex-column">
                        <a href="<?= base_url('delivery/dashboard') ?>" class="nav-link">
                            <i class="bi bi-speedometer2"></i> Dashboard
                        </a>
                        <a href="<?= base_url('delivery/history') ?>" class="nav-link">
                            <i class="bi bi-clock-history"></i> History
                        </a>
                        <a href="<?= base_url('delivery/earnings') ?>" class="nav-link">
                            <i class="bi bi-currency-rupee"></i> Earnings
                        </a>
                        <a href="<?= base_url('auth/logout') ?>" class="nav-link mt-4">
                            <i class="bi bi-box-arrow-right"></i> Logout
                        </a>
                    </nav>
                </div>
            </div>

            <!-- Main Content -->
            <div class="col-md-9 col-lg-10 p-4">
                <div class="d-flex justify-content-between align-items-center mb-4">
                    <div>
                        <h2><i class="bi bi-box-seam"></i> Order #<?= esc($order['id']) ?></h2>
                        <p class="text-muted mb-0">Delivery Details</p>
                    </div>
                    <a href="<?= base_url('delivery/dashboard') ?>" class="btn btn-outline-secondary">
                        <i class="bi bi-arrow-left"></i> Back
                    </a>
                </div>

                <div class="row g-4">
                    <!-- Order Info -->
                    <div class="col-md-8">
                        <div class="info-box mb-4">
                            <h5 class="mb-3"><i class="bi bi-info-circle"></i> Order Information</h5>
                            <div class="row">
                                <div class="col-md-6 mb-3">
                                    <small class="text-muted">Product Name</small>
                                    <p class="mb-0 fw-bold"><?= esc($order['product_name']) ?></p>
                                </div>
                                <div class="col-md-6 mb-3">
                                    <small class="text-muted">Order Type</small>
                                    <p class="mb-0 fw-bold"><?= ucfirst($order['order_type']) ?></p>
                                </div>
                                <div class="col-md-6 mb-3">
                                    <small class="text-muted">Amount</small>
                                    <p class="mb-0 fw-bold">₹<?= number_format($order['final_price']) ?></p>
                                </div>
                                <div class="col-md-6 mb-3">
                                    <small class="text-muted">Payment Method</small>
                                    <p class="mb-0 fw-bold"><?= ucfirst($order['payment_method']) ?></p>
                                </div>
                            </div>
                        </div>

                        <div class="info-box mb-4">
                            <h5 class="mb-3"><i class="bi bi-person"></i> Buyer Details</h5>
                            <p class="mb-1"><strong>Name:</strong> <?= esc($buyerDetails['name']) ?></p>
                            <p class="mb-1"><strong>Mobile:</strong> <?= esc($buyerDetails['mobile']) ?></p>
                            <p class="mb-1"><strong>Address:</strong> <?= esc($order['delivery_address'] ?? 'N/A') ?></p>
                        </div>

                        <div class="info-box">
                            <h5 class="mb-3"><i class="bi bi-shop"></i> Seller Details</h5>
                            <p class="mb-1"><strong>Name:</strong> <?= esc($sellerDetails['name']) ?></p>
                            <p class="mb-1"><strong>Mobile:</strong> <?= esc($sellerDetails['mobile']) ?></p>
                            <p class="mb-1"><strong>Pickup Address:</strong> <?= esc($order['pickup_address'] ?? 'N/A') ?></p>
                        </div>
                    </div>

                    <!-- Status & Actions -->
                    <div class="col-md-4">
                        <div class="info-box mb-4">
                            <h5 class="mb-3">Current Status</h5>
                            <div class="badge bg-<?= $order['status'] === 'delivered' ? 'success' : ($order['status'] === 'in_transit' ? 'primary' : 'warning') ?> fs-6 mb-3">
                                <?= ucwords(str_replace('_', ' ', $order['status'])) ?>
                            </div>
                            
                            <?php if ($order['status'] === 'dispatched'): ?>
                                <button onclick="markPickedUp()" class="btn btn-primary w-100 mb-2">
                                    <i class="bi bi-box-seam"></i> Mark as Picked Up
                                </button>
                            <?php elseif ($order['status'] === 'in_transit'): ?>
                                <button onclick="markDelivered()" class="btn btn-success w-100 mb-2">
                                    <i class="bi bi-check-circle"></i> Mark as Delivered
                                </button>
                            <?php endif; ?>
                            
                            <a href="tel:<?= esc($buyerDetails['mobile']) ?>" class="btn btn-outline-primary w-100 mb-2">
                                <i class="bi bi-telephone"></i> Call Buyer
                            </a>
                            <a href="tel:<?= esc($sellerDetails['mobile']) ?>" class="btn btn-outline-secondary w-100">
                                <i class="bi bi-telephone"></i> Call Seller
                            </a>
                        </div>

                        <div class="info-box">
                            <h5 class="mb-3"><i class="bi bi-clock-history"></i> Status History</h5>
                            <div class="timeline">
                                <?php if (!empty($statusHistory)): ?>
                                    <?php foreach (array_reverse($statusHistory) as $history): ?>
                                        <div class="timeline-item">
                                            <small class="text-muted"><?= date('d M, H:i', strtotime($history['created_at'])) ?></small>
                                            <p class="mb-0 fw-bold"><?= ucwords(str_replace('_', ' ', $history['status'])) ?></p>
                                        </div>
                                    <?php endforeach; ?>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
    <script>
        function markPickedUp() {
            Swal.fire({
                title: 'Confirm Pickup',
                text: 'Have you picked up the product from seller?',
                icon: 'question',
                showCancelButton: true,
                confirmButtonText: 'Yes, Picked Up',
                confirmButtonColor: '#00897b'
            }).then((result) => {
                if (result.isConfirmed) {
                    fetch('/delivery/mark-picked-up/<?= $order['id'] ?>', {
                        method: 'POST',
                        headers: {
                            'Content-Type': 'application/json',
                            'X-Requested-With': 'XMLHttpRequest'
                        }
                    })
                    .then(response => response.json())
                    .then(data => {
                        if (data.status === 'success') {
                            Swal.fire('Success!', data.message, 'success').then(() => {
                                location.reload();
                            });
                        } else {
                            Swal.fire('Error!', data.message, 'error');
                        }
                    })
                    .catch(error => {
                        Swal.fire('Error!', 'Something went wrong', 'error');
                    });
                }
            });
        }

        function markDelivered() {
            Swal.fire({
                title: 'Confirm Delivery',
                text: 'Have you delivered the product to buyer?',
                icon: 'question',
                showCancelButton: true,
                confirmButtonText: 'Yes, Delivered',
                confirmButtonColor: '#4caf50'
            }).then((result) => {
                if (result.isConfirmed) {
                    fetch('/delivery/mark-delivered/<?= $order['id'] ?>', {
                        method: 'POST',
                        headers: {
                            'Content-Type': 'application/json',
                            'X-Requested-With': 'XMLHttpRequest'
                        }
                    })
                    .then(response => response.json())
                    .then(data => {
                        if (data.status === 'success') {
                            Swal.fire('Success!', data.message, 'success').then(() => {
                                location.reload();
                            });
                        } else {
                            Swal.fire('Error!', data.message, 'error');
                        }
                    })
                    .catch(error => {
                        Swal.fire('Error!', 'Something went wrong', 'error');
                    });
                }
            });
        }
    </script>
</body>
</html>
