<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>User Management - Flex Market</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.css">
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <style>
        * { font-family: 'Poppins', sans-serif; }
        body { background: #f5f5f5; }
        .sidebar {
            min-height: 100vh;
            background: linear-gradient(180deg, #1a237e 0%, #0d47a1 100%);
        }
        .sidebar .nav-link {
            color: rgba(255,255,255,0.85);
            padding: 14px 20px;
            border-radius: 10px;
            margin: 6px 0;
        }
        .sidebar .nav-link:hover, .sidebar .nav-link.active {
            background: rgba(255,255,255,0.15);
            color: #fff;
        }
        .sidebar .nav-link i { margin-right: 10px; }
    </style>
</head>
<body>
    <div class="container-fluid">
        <div class="row">
            <!-- Sidebar -->
            <div class="col-md-3 col-lg-2 px-0 sidebar">
                <div class="p-3">
                    <h4 class="text-white mb-4"><i class="bi bi-shield-check"></i> Super Admin</h4>
                    <nav class="nav flex-column">
                        <a href="<?= base_url('superadmin/dashboard') ?>" class="nav-link">
                            <i class="bi bi-speedometer2"></i> Dashboard
                        </a>
                        <a href="<?= base_url('superadmin/users') ?>" class="nav-link active">
                            <i class="bi bi-people"></i> Users
                        </a>
                        <a href="<?= base_url('superadmin/admins') ?>" class="nav-link">
                            <i class="bi bi-person-badge"></i> Admins
                        </a>
                        <a href="<?= base_url('superadmin/settings') ?>" class="nav-link">
                            <i class="bi bi-gear"></i> Settings
                        </a>
                        <a href="<?= base_url('superadmin/reports') ?>" class="nav-link">
                            <i class="bi bi-file-earmark-text"></i> Reports
                        </a>
                        <a href="<?= base_url('auth/logout') ?>" class="nav-link mt-4">
                            <i class="bi bi-box-arrow-right"></i> Logout
                        </a>
                    </nav>
                </div>
            </div>

            <!-- Main Content -->
            <div class="col-md-9 col-lg-10 p-4">
                <h2 class="mb-4"><i class="bi bi-people"></i> User Management</h2>

                <!-- Filter -->
                <div class="card border-0 shadow-sm mb-4">
                    <div class="card-body">
                        <form method="get" class="row g-3">
                            <div class="col-md-4">
                                <label class="form-label">User Type</label>
                                <select name="type" class="form-select">
                                    <option value="">All Types</option>
                                    <option value="buyer" <?= (isset($_GET['type']) && $_GET['type'] === 'buyer') ? 'selected' : '' ?>>Buyer</option>
                                    <option value="seller" <?= (isset($_GET['type']) && $_GET['type'] === 'seller') ? 'selected' : '' ?>>Seller</option>
                                    <option value="delivery" <?= (isset($_GET['type']) && $_GET['type'] === 'delivery') ? 'selected' : '' ?>>Delivery</option>
                                    <option value="admin" <?= (isset($_GET['type']) && $_GET['type'] === 'admin') ? 'selected' : '' ?>>Admin</option>
                                </select>
                            </div>
                            <div class="col-md-4">
                                <label class="form-label">Status</label>
                                <select name="status" class="form-select">
                                    <option value="">All Status</option>
                                    <option value="active" <?= (isset($_GET['status']) && $_GET['status'] === 'active') ? 'selected' : '' ?>>Active</option>
                                    <option value="suspended" <?= (isset($_GET['status']) && $_GET['status'] === 'suspended') ? 'selected' : '' ?>>Suspended</option>
                                </select>
                            </div>
                            <div class="col-md-4">
                                <label class="form-label">&nbsp;</label>
                                <button type="submit" class="btn btn-primary w-100">
                                    <i class="bi bi-search"></i> Filter
                                </button>
                            </div>
                        </form>
                    </div>
                </div>

                <div class="card border-0 shadow-sm">
                    <div class="card-body">
                        <table class="table table-hover">
                            <thead>
                                <tr>
                                    <th>ID</th>
                                    <th>Name</th>
                                    <th>Email</th>
                                    <th>Mobile</th>
                                    <th>Type</th>
                                    <th>Status</th>
                                    <th>Joined</th>
                                    <th>Action</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php if (!empty($users)): ?>
                                    <?php foreach ($users as $user): ?>
                                        <tr>
                                            <td><?= esc($user['id']) ?></td>
                                            <td><?= esc($user['name']) ?></td>
                                            <td><?= esc($user['email']) ?></td>
                                            <td><?= esc($user['mobile']) ?></td>
                                            <td><span class="badge bg-primary"><?= ucfirst($user['user_type']) ?></span></td>
                                            <td>
                                                <span class="badge bg-<?= $user['is_verified'] ? 'success' : 'danger' ?>">
                                                    <?= $user['is_verified'] ? 'Active' : 'Suspended' ?>
                                                </span>
                                            </td>
                                            <td><?= date('d M Y', strtotime($user['created_at'])) ?></td>
                                            <td>
                                                <button onclick="toggleStatus(<?= $user['id'] ?>, <?= $user['is_verified'] ?>)" 
                                                        class="btn btn-sm btn-<?= $user['is_verified'] ? 'danger' : 'success' ?>">
                                                    <i class="bi bi-<?= $user['is_verified'] ? 'x-circle' : 'check-circle' ?>"></i>
                                                    <?= $user['is_verified'] ? 'Suspend' : 'Activate' ?>
                                                </button>
                                            </td>
                                        </tr>
                                    <?php endforeach; ?>
                                <?php else: ?>
                                    <tr>
                                        <td colspan="8" class="text-center text-muted">No users found</td>
                                    </tr>
                                <?php endif; ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
    <script>
        function toggleStatus(userId, currentStatus) {
            const action = currentStatus ? 'suspend' : 'activate';
            Swal.fire({
                title: 'Are you sure?',
                text: `Do you want to ${action} this user?`,
                icon: 'warning',
                showCancelButton: true,
                confirmButtonText: `Yes, ${action}!`,
                confirmButtonColor: currentStatus ? '#dc3545' : '#28a745'
            }).then((result) => {
                if (result.isConfirmed) {
                    fetch('/superadmin/toggle-user-status/' + userId, {
                        method: 'POST'
                    })
                    .then(response => response.json())
                    .then(data => {
                        if (data.status === 'success') {
                            Swal.fire('Success!', data.message, 'success').then(() => {
                                location.reload();
                            });
                        } else {
                            Swal.fire('Error!', data.message, 'error');
                        }
                    });
                }
            });
        }
    </script>
</body>
</html>
